/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.utils;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.reflect.Reflects;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;

public class Connections {
    private static final Method CONNECTION_GET_SCHEMA = Reflects.getDeclaredMethod(Connection.class, (String)"getSchema", (Class[])new Class[0]);

    public static String getCatalog(Connection connection) {
        Preconditions.checkNotNull((Object)connection);
        try {
            return connection.getCatalog();
        }
        catch (SQLException ex) {
            return null;
        }
    }

    public static String getSchema(Connection connection) {
        Preconditions.checkNotNull((Object)connection);
        if (CONNECTION_GET_SCHEMA != null) {
            try {
                return (String)Reflects.invoke((Method)CONNECTION_GET_SCHEMA, (Object)connection, null, (boolean)true, (boolean)true);
            }
            catch (Throwable ex) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDatabaseProductName(DataSource dataSource) throws SQLException {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            String string = metaData.getDatabaseProductName();
            return string;
        }
        finally {
            IOs.close((Object)conn);
        }
    }
}

