/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.transaction.utils;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.enums.Enums;
import com.jn.sqlhelper.common.transaction.utils.Isolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transactions {
    private static final Logger logger = LoggerFactory.getLogger(Transactions.class);

    private Transactions() {
    }

    public static boolean isValidIsolation(Isolation isolation) {
        return isolation != null && isolation != Isolation.DEFAULT;
    }

    public static final int getTransactionIsolationLevel(@Nullable String transactionIsolationName) {
        Isolation isolation = Transactions.getTransactionIsolation(transactionIsolationName);
        return isolation.getCode();
    }

    public static final Isolation getTransactionIsolation(@Nullable String transactionIsolationName) {
        return Transactions.getTransactionIsolation(transactionIsolationName, Isolation.DEFAULT);
    }

    public static final Isolation getTransactionIsolation(@Nullable String transactionIsolationName, @Nullable Isolation ifNull) {
        Isolation isolation = null;
        if (Emptys.isNotEmpty((Object)transactionIsolationName) && (isolation = (Isolation)Enums.ofDisplayText(Isolation.class, (String)transactionIsolationName)) == null) {
            isolation = (Isolation)Enums.ofName(Isolation.class, (String)transactionIsolationName);
        }
        if (isolation == null) {
            logger.warn("the transactionIsolationName is invalid: {}", (Object)transactionIsolationName);
            isolation = ifNull;
        }
        return isolation;
    }
}

