/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.transaction.jdbc;

import com.jn.sqlhelper.common.transaction.TransactionalResource;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionTransactionalResource
implements TransactionalResource {
    private Connection connection;
    private String name = "undefined";

    public ConnectionTransactionalResource(Connection connection) {
        this.setConnection(connection);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void commit(boolean force) throws SQLException {
        if (this.connection != null && !this.connection.isClosed() && force) {
            this.connection.commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.rollback();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isClosed() {
        try {
            return this.connection == null || this.connection.isClosed();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }
}

