/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.transaction;

import com.jn.sqlhelper.common.transaction.TransactionDefinition;
import com.jn.sqlhelper.common.transaction.TransactionManager;
import com.jn.sqlhelper.common.transaction.TransactionalResource;
import java.util.LinkedHashMap;
import java.util.Map;

public class Transaction {
    private TransactionManager transactionManager;
    private TransactionDefinition definition;
    private boolean rollbackOnly = false;
    private final Map<Object, TransactionalResource> resources = new LinkedHashMap<Object, TransactionalResource>();

    public Transaction(TransactionManager transactionManager, TransactionDefinition definition) {
        this.setDefinition(definition);
        this.setTransactionManager(transactionManager);
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setDefinition(TransactionDefinition definition) {
        this.definition = definition;
    }

    public TransactionDefinition getTransactionDefinition() {
        return this.definition;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public void bindResource(Object key, TransactionalResource transactionalResource) {
        if (key == null) {
            return;
        }
        this.resources.put(key, transactionalResource);
    }

    public boolean hasResource(Object key) {
        if (key == null) {
            return false;
        }
        return this.resources.containsKey(key);
    }

    public void unbindResource(Object key) {
        if (key != null) {
            this.resources.remove(key);
        }
    }

    public void clearResources() {
        this.resources.clear();
    }

    public Map<Object, TransactionalResource> getResources() {
        return this.resources;
    }

    public TransactionalResource getResource(Object key) {
        return this.resources.get(key);
    }

    public String toString() {
        return this.definition.toString();
    }
}

