/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.transaction;

import com.jn.sqlhelper.common.transaction.Transaction;
import com.jn.sqlhelper.common.transaction.TransactionDefinition;
import com.jn.sqlhelper.common.transaction.TransactionManager;
import com.jn.sqlhelper.common.transaction.TransactionalResource;
import java.sql.SQLException;
import java.util.Map;

public class DefaultTransactionManager
implements TransactionManager {
    @Override
    public Transaction createTransaction(TransactionDefinition transactionDefinition) {
        return new Transaction(this, transactionDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Transaction transaction) throws SQLException {
        if (transaction.isRollbackOnly()) {
            this.rollback(transaction);
            return;
        }
        Map<Object, TransactionalResource> resourceMap = transaction.getResources();
        SQLException exception = null;
        for (Map.Entry<Object, TransactionalResource> resourceEntry : resourceMap.entrySet()) {
            TransactionalResource resource = resourceEntry.getValue();
            if (resource.isClosed()) continue;
            try {
                resource.commit(true);
            }
            catch (SQLException ex) {
                exception = ex;
            }
            finally {
                resource.close();
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Transaction transaction) throws SQLException {
        Map<Object, TransactionalResource> resourceMap = transaction.getResources();
        SQLException exception = null;
        for (Map.Entry<Object, TransactionalResource> resourceEntry : resourceMap.entrySet()) {
            TransactionalResource resource = resourceEntry.getValue();
            if (resource.isClosed()) continue;
            try {
                resource.rollback();
            }
            catch (SQLException ex) {
                exception = ex;
            }
            finally {
                resource.close();
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

