/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.symbolmapper;

import com.jn.langx.util.Chars;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.sqlhelper.common.symbolmapper.SqlSymbolMapper;
import java.util.List;

public class CamelToUnderlineSymbolMapper
implements SqlSymbolMapper {
    private boolean uppercase = true;
    private String prefix;
    private String suffix;

    public CamelToUnderlineSymbolMapper() {
        this(false);
    }

    public CamelToUnderlineSymbolMapper(boolean uppercase) {
        this(uppercase, null);
    }

    public CamelToUnderlineSymbolMapper(String prefix, boolean uppercase) {
        this(uppercase, prefix, null);
    }

    public CamelToUnderlineSymbolMapper(boolean uppercase, String suffix) {
        this(uppercase, null, suffix);
    }

    public CamelToUnderlineSymbolMapper(boolean uppercase, String prefix, String suffix) {
        this.uppercase = uppercase;
        this.prefix = Strings.isEmpty((String)prefix) ? "" : prefix;
        this.suffix = Strings.isEmpty((String)suffix) ? "" : suffix;
    }

    public String apply(String name) {
        Preconditions.checkNotEmpty((Object)name);
        int startIndex = 0;
        List segments = Collects.emptyArrayList();
        boolean lastCharIsUnderline = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                if (startIndex > -1 && i > 0) {
                    segments.add(name.substring(startIndex, i));
                }
                lastCharIsUnderline = true;
                startIndex = -1;
                continue;
            }
            if (lastCharIsUnderline) {
                startIndex = i;
            } else if (Chars.isUpperCase((char)c)) {
                if (startIndex > -1 && i > 0) {
                    segments.add(name.substring(startIndex, i));
                }
                startIndex = i;
            }
            lastCharIsUnderline = false;
        }
        if (startIndex > -1) {
            segments.add(name.substring(startIndex));
        }
        StringBuilder stringBuilder = new StringBuilder(name.length() + 20);
        stringBuilder.append(this.prefix);
        for (int i = 0; i < segments.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("_");
            }
            stringBuilder.append((String)segments.get(i));
        }
        stringBuilder.append(this.suffix);
        return this.uppercase ? stringBuilder.toString().toUpperCase() : stringBuilder.toString().toLowerCase();
    }
}

