/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.resultset;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.ThrowableFunction;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.sqlhelper.common.ddl.model.internal.JdbcType;
import java.sql.ResultSetMetaData;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetDescription {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetDescription.class);
    private ResultSetMetaData resultSetMetaData;
    private int columnCount = -1;
    private List<Boolean> isAutoIncrement;
    private List<Boolean> isCaseSensitive;
    private List<Boolean> isSearchable;
    private List<Boolean> isCurrency;
    private List<Integer> isNullable;
    public static final int columnNoNulls = 0;
    int columnNullable = 1;
    public static final int columnNullableUnknown = 2;
    private List<Boolean> isSigned;
    private List<Integer> columnDisplaySizes;
    private List<String> columnLabels;
    private List<String> columnNames;
    private List<String> schemaNames;
    private List<Integer> precisions;
    private List<Integer> scales;
    private List<String> tableNames;
    private List<String> catalogNames;
    private List<JdbcType> jdbcTypes;
    private List<String> columnJdbcTypeNames;
    private List<Boolean> isReadOnly;
    private List<Boolean> isWritable;
    private List<Boolean> isDefinitelyWritable;
    private List<String> columnClassNames;

    public ResultSetDescription(ResultSetMetaData resultSetMetaData) {
        Preconditions.checkNotNull((Object)resultSetMetaData);
        this.resultSetMetaData = resultSetMetaData;
        this.getColumnCount();
    }

    public int getColumnCount() {
        if (this.columnCount < 0) {
            this.parseColumnCount();
        }
        return this.columnCount;
    }

    private void parseColumnCount() {
        this.columnCount = (Integer)Throwables.ignoreThrowable((Logger)logger, (Object)0, (ThrowableFunction)new ThrowableFunction<Object, Integer>(){

            public Integer doFun(Object o) throws Throwable {
                return ResultSetDescription.this.resultSetMetaData.getColumnCount();
            }
        }, (Object)this.resultSetMetaData);
    }

    public boolean isAutoIncrement(int column) {
        if (this.isAutoIncrement == null) {
            this.parseIsAutoIncrement();
        }
        return this.isAutoIncrement.get(column - 1);
    }

    private void parseIsAutoIncrement() {
        final List isAutoIncrement = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                isAutoIncrement.add(Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Integer, Boolean>(){

                    public Boolean doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.isAutoIncrement(column);
                    }
                }, (Object)column));
            }
        });
        this.isAutoIncrement = isAutoIncrement;
    }

    public boolean isCaseSensitive(int column) {
        if (this.isCaseSensitive == null) {
            this.parseIsCaseSensitive();
        }
        return this.isCaseSensitive.get(column - 1);
    }

    private void parseIsCaseSensitive() {
        final List isCaseSensitive = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                isCaseSensitive.add(Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Integer, Boolean>(){

                    public Boolean doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.isCaseSensitive(column);
                    }
                }, (Object)column));
            }
        });
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean isSearchable(int column) {
        if (this.isSearchable == null) {
            this.parseIsCaseSensitive();
        }
        return this.isSearchable.get(column - 1);
    }

    private void parseIsSearchable() {
        final List isSearchable = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                isSearchable.add(Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Integer, Boolean>(){

                    public Boolean doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.isSearchable(column);
                    }
                }, (Object)column));
            }
        });
        this.isSearchable = isSearchable;
    }

    public boolean isCurrency(int column) {
        if (this.isCurrency == null) {
            this.parseIsCurrency();
        }
        return this.isCurrency.get(column - 1);
    }

    private void parseIsCurrency() {
        final List isCurrency = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                isCurrency.add(Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Integer, Boolean>(){

                    public Boolean doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.isSearchable(column);
                    }
                }, (Object)column));
            }
        });
        this.isCurrency = isCurrency;
    }

    public int isNullable(int column) {
        if (this.isNullable == null) {
            this.parseIsNullable();
        }
        return this.isNullable.get(column - 1);
    }

    private void parseIsNullable() {
        final List isNullable = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                isNullable.add(Throwables.ignoreThrowable((Logger)logger, (Object)2, (ThrowableFunction)new ThrowableFunction<Integer, Integer>(){

                    public Integer doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.isNullable(column);
                    }
                }, (Object)column));
            }
        });
        this.isNullable = isNullable;
    }

    public boolean isSigned(int column) {
        if (this.isSigned == null) {
            this.parseIsSigned();
        }
        return this.isSigned.get(column - 1);
    }

    private void parseIsSigned() {
        final List isSigned = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                isSigned.add(Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Integer, Boolean>(){

                    public Boolean doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.isSigned(column);
                    }
                }, (Object)column));
            }
        });
        this.isSigned = isSigned;
    }

    public int getColumnDisplaySize(int column) {
        if (this.columnDisplaySizes == null) {
            this.parseColumnDisplaySizes();
        }
        return this.columnDisplaySizes.get(column - 1);
    }

    private void parseColumnDisplaySizes() {
        final List columnDisplaySizes = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                columnDisplaySizes.add(Throwables.ignoreThrowable((Logger)logger, (Object)2, (ThrowableFunction)new ThrowableFunction<Integer, Integer>(){

                    public Integer doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.getColumnDisplaySize(column);
                    }
                }, (Object)column));
            }
        });
        this.columnDisplaySizes = columnDisplaySizes;
    }

    public String getColumnLabel(int column) {
        if (this.columnLabels == null) {
            this.parseColumnLabels();
        }
        return this.columnLabels.get(column - 1);
    }

    private void parseColumnLabels() {
        final List columnLabels = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                columnLabels.add(Throwables.ignoreThrowable((Logger)logger, (Object)ResultSetDescription.this.getColumnName(column), (ThrowableFunction)new ThrowableFunction<Integer, String>(){

                    public String doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.getColumnLabel(column);
                    }
                }, (Object)column));
            }
        });
        this.columnLabels = columnLabels;
    }

    public String getColumnName(int column) {
        if (this.columnNames == null) {
            this.parseColumnNames();
        }
        return this.columnNames.get(column - 1);
    }

    private void parseColumnNames() {
        final List columnNames = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                columnNames.add(Throwables.ignoreThrowable((Logger)logger, (Object)"_UNKnown_", (ThrowableFunction)new ThrowableFunction<Integer, String>(){

                    public String doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.getColumnName(column);
                    }
                }, (Object)column));
            }
        });
        this.columnNames = columnNames;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public String getSchemaName(int column) {
        if (this.schemaNames == null) {
            this.parseSchemaNames();
        }
        return this.schemaNames.get(column - 1);
    }

    private void parseSchemaNames() {
        final List schemaNames = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                schemaNames.add(Throwables.ignoreThrowable((Logger)logger, (Object)"", (ThrowableFunction)new ThrowableFunction<Integer, String>(){

                    public String doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.getSchemaName(column);
                    }
                }, (Object)column));
            }
        });
        this.schemaNames = schemaNames;
    }

    public int getPrecision(int column) {
        if (this.precisions == null) {
            this.parsePrecisions();
        }
        return this.precisions.get(column - 1);
    }

    private void parsePrecisions() {
        final List precisions = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                precisions.add(Throwables.ignoreThrowable((Logger)logger, (Object)0, (ThrowableFunction)new ThrowableFunction<Integer, Integer>(){

                    public Integer doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.getPrecision(column);
                    }
                }, (Object)column));
            }
        });
        this.precisions = precisions;
    }

    public int getScale(int column) {
        if (this.scales == null) {
            this.parseScales();
        }
        return this.scales.get(column - 1);
    }

    private void parseScales() {
        final List scales = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                scales.add(Throwables.ignoreThrowable((Logger)logger, (Object)0, (ThrowableFunction)new ThrowableFunction<Integer, Integer>(){

                    public Integer doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.getScale(column);
                    }
                }, (Object)column));
            }
        });
        this.scales = scales;
    }

    public String getTableName(int column) {
        if (this.tableNames == null) {
            this.parseTableNames();
        }
        return this.tableNames.get(column - 1);
    }

    private void parseTableNames() {
        final List tableNames = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                tableNames.add(Throwables.ignoreThrowable((Logger)logger, (Object)"", (ThrowableFunction)new ThrowableFunction<Integer, String>(){

                    public String doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.getTableName(column);
                    }
                }, (Object)column));
            }
        });
        this.tableNames = tableNames;
    }

    public String getCatalogName(int column) {
        if (this.catalogNames == null) {
            this.parseCatalogNames();
        }
        return this.catalogNames.get(column - 1);
    }

    private void parseCatalogNames() {
        final List catalogNames = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                catalogNames.add(Throwables.ignoreThrowable((Logger)logger, (Object)"", (ThrowableFunction)new ThrowableFunction<Integer, String>(){

                    public String doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.getCatalogName(column);
                    }
                }, (Object)column));
            }
        });
        this.catalogNames = catalogNames;
    }

    private void parseColumnTypes() {
        final List jdbcTypes = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                jdbcTypes.add(Throwables.ignoreThrowable((Logger)logger, (Object)((Object)JdbcType.UNKNOWN), (ThrowableFunction)new ThrowableFunction<Integer, JdbcType>(){

                    public JdbcType doFun(Integer column) throws Throwable {
                        return JdbcType.ofCode(ResultSetDescription.this.resultSetMetaData.getColumnType(column));
                    }
                }, (Object)column));
            }
        });
        this.jdbcTypes = jdbcTypes;
    }

    public JdbcType getColumnType(int column) {
        if (this.jdbcTypes == null) {
            this.parseColumnTypes();
        }
        return this.jdbcTypes.get(column - 1);
    }

    public String getColumnTypeName(int column) {
        if (this.columnJdbcTypeNames == null) {
            this.parseColumnJdbcTypeNames();
        }
        return this.columnJdbcTypeNames.get(column - 1);
    }

    private void parseColumnJdbcTypeNames() {
        final List columnJdbcTypeNames = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                columnJdbcTypeNames.add(Throwables.ignoreThrowable((Logger)logger, (Object)"", (ThrowableFunction)new ThrowableFunction<Integer, String>(){

                    public String doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.getColumnTypeName(column);
                    }
                }, (Object)column));
            }
        });
        this.columnJdbcTypeNames = columnJdbcTypeNames;
    }

    public boolean isReadOnly(int column) {
        if (this.isReadOnly == null) {
            this.parseIsReadOnly();
        }
        return this.isReadOnly.get(column - 1);
    }

    private void parseIsReadOnly() {
        final List isReadOnly = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                isReadOnly.add(Throwables.ignoreThrowable((Logger)logger, (Object)true, (ThrowableFunction)new ThrowableFunction<Integer, Boolean>(){

                    public Boolean doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.isReadOnly(column);
                    }
                }, (Object)column));
            }
        });
        this.isReadOnly = isReadOnly;
    }

    public boolean isWritable(int column) {
        if (this.isWritable == null) {
            this.parseIsWritable();
        }
        return this.isWritable.get(column - 1);
    }

    private void parseIsWritable() {
        final List isWritable = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                isWritable.add(Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Integer, Boolean>(){

                    public Boolean doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.isWritable(column);
                    }
                }, (Object)column));
            }
        });
        this.isWritable = isWritable;
    }

    public boolean isDefinitelyWritable(int column) {
        if (this.isDefinitelyWritable == null) {
            this.parseIsDefinitelyWritable();
        }
        return this.isDefinitelyWritable.get(column - 1);
    }

    private void parseIsDefinitelyWritable() {
        final List isDefinitelyWritable = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                isDefinitelyWritable.add(Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Integer, Boolean>(){

                    public Boolean doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.isDefinitelyWritable(column);
                    }
                }, (Object)column));
            }
        });
        this.isDefinitelyWritable = isDefinitelyWritable;
    }

    public String getColumnClassName(int column) {
        if (this.columnClassNames == null) {
            this.parseColumnClassNames();
        }
        return this.columnClassNames.get(column - 1);
    }

    private void parseColumnClassNames() {
        final List columnClassNames = Collects.emptyArrayList();
        Collects.forEach((Object[])Arrs.range((int)1, (int)(this.columnCount + 1)), (Consumer)new Consumer<Integer>(){

            public void accept(Integer column) {
                columnClassNames.add(Throwables.ignoreThrowable((Logger)logger, (Object)"", (ThrowableFunction)new ThrowableFunction<Integer, String>(){

                    public String doFun(Integer column) throws Throwable {
                        return ResultSetDescription.this.resultSetMetaData.getColumnClassName(column);
                    }
                }, (Object)column));
            }
        });
        this.columnClassNames = columnClassNames;
    }
}

