/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.ddl.model;

import com.jn.langx.util.ThrowableFunction;
import com.jn.langx.util.Throwables;
import java.sql.DatabaseMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDescription {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseDescription.class);
    private DatabaseMetaData dbMetaData;
    private Boolean allProceduresAreCallable;
    private Boolean supportsMixedCaseIdentifiers;
    private Boolean supportsMixedCaseQuotedIdentifiers;
    private Boolean supportsSchemasInTableDefinitions;
    private Boolean supportsSchemasInIndexDefinitions;
    private Boolean supportsCatalogsInTableDefinitions;
    private Boolean supportsCatalogsInIndexDefinitions;
    private String catalogSeparator;
    private Boolean isCatalogAtStart = null;
    private Boolean isSupportsBatchUpdates = null;

    public DatabaseDescription(DatabaseMetaData databaseMetaData) {
        this.dbMetaData = databaseMetaData;
    }

    private void parseAllProceduresAreCallable() {
        this.allProceduresAreCallable = (Boolean)Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Object, Boolean>(){

            public Boolean doFun(Object o) throws Throwable {
                return DatabaseDescription.this.dbMetaData.allProceduresAreCallable();
            }
        }, null);
    }

    public boolean allProceduresAreCallable() {
        if (this.allProceduresAreCallable == null) {
            this.parseAllProceduresAreCallable();
        }
        return this.allProceduresAreCallable;
    }

    private void parseSupportsMixedCaseIdentifiers() {
        this.supportsMixedCaseIdentifiers = (Boolean)Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Object, Boolean>(){

            public Boolean doFun(Object o) throws Throwable {
                return DatabaseDescription.this.dbMetaData.supportsMixedCaseIdentifiers();
            }
        }, null);
    }

    public boolean supportsMixedCaseIdentifiers() {
        if (this.supportsMixedCaseIdentifiers == null) {
            this.parseSupportsMixedCaseIdentifiers();
        }
        return this.supportsMixedCaseIdentifiers;
    }

    private void parseSupportsMixedCaseQuotedIdentifiers() {
        this.supportsMixedCaseQuotedIdentifiers = (Boolean)Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Object, Boolean>(){

            public Boolean doFun(Object o) throws Throwable {
                return DatabaseDescription.this.dbMetaData.supportsMixedCaseQuotedIdentifiers();
            }
        }, null);
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        if (this.supportsMixedCaseQuotedIdentifiers == null) {
            this.parseSupportsMixedCaseQuotedIdentifiers();
        }
        return this.supportsMixedCaseQuotedIdentifiers;
    }

    private void parseSupportsSchemasInTableDefinitions() {
        this.supportsSchemasInTableDefinitions = (Boolean)Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Object, Boolean>(){

            public Boolean doFun(Object o) throws Throwable {
                return DatabaseDescription.this.dbMetaData.supportsSchemasInTableDefinitions();
            }
        }, null);
    }

    public boolean supportsSchemasInTableDefinitions() {
        if (this.supportsSchemasInTableDefinitions == null) {
            this.parseSupportsSchemasInTableDefinitions();
        }
        return this.supportsSchemasInTableDefinitions;
    }

    private void parseSupportsSchemasInIndexDefinitions() {
        this.supportsSchemasInIndexDefinitions = (Boolean)Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Object, Boolean>(){

            public Boolean doFun(Object o) throws Throwable {
                return DatabaseDescription.this.dbMetaData.supportsSchemasInIndexDefinitions();
            }
        }, null);
    }

    public boolean supportsSchemasInIndexDefinitions() {
        if (this.supportsSchemasInIndexDefinitions == null) {
            this.parseSupportsSchemasInIndexDefinitions();
        }
        return this.supportsSchemasInIndexDefinitions;
    }

    private void parseSupportsCatalogsInTableDefinitions() {
        this.supportsCatalogsInTableDefinitions = (Boolean)Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Object, Boolean>(){

            public Boolean doFun(Object o) throws Throwable {
                return DatabaseDescription.this.dbMetaData.supportsCatalogsInTableDefinitions();
            }
        }, null);
    }

    public boolean supportsCatalogsInTableDefinitions() {
        if (this.supportsCatalogsInTableDefinitions == null) {
            this.parseSupportsCatalogsInTableDefinitions();
        }
        return this.supportsCatalogsInTableDefinitions;
    }

    private void parseSupportsCatalogsInIndexDefinitions() {
        this.supportsCatalogsInIndexDefinitions = (Boolean)Throwables.ignoreThrowable((Logger)logger, (Object)false, (ThrowableFunction)new ThrowableFunction<Object, Boolean>(){

            public Boolean doFun(Object o) throws Throwable {
                return DatabaseDescription.this.dbMetaData.supportsCatalogsInIndexDefinitions();
            }
        }, null);
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        if (this.supportsCatalogsInIndexDefinitions == null) {
            this.parseSupportsCatalogsInIndexDefinitions();
        }
        return this.supportsCatalogsInIndexDefinitions;
    }

    public DatabaseMetaData getDbMetaData() {
        return this.dbMetaData;
    }

    private void parseCatalogSeparator() {
        this.catalogSeparator = (String)Throwables.ignoreThrowable((Logger)logger, (Object)".", (ThrowableFunction)new ThrowableFunction<Object, String>(){

            public String doFun(Object o) throws Throwable {
                return DatabaseDescription.this.dbMetaData.getCatalogSeparator();
            }
        }, null);
    }

    public String getCatalogSeparator() {
        if (this.catalogSeparator == null) {
            this.parseCatalogSeparator();
        }
        return this.catalogSeparator;
    }

    private void parseIsCatalogAtStart() {
        this.isCatalogAtStart = (Boolean)Throwables.ignoreThrowable((Logger)logger, (Object)true, (ThrowableFunction)new ThrowableFunction<Object, Boolean>(){

            public Boolean doFun(Object o) throws Throwable {
                return DatabaseDescription.this.dbMetaData.isCatalogAtStart();
            }
        }, null);
    }

    public boolean isCatalogAtStart() {
        if (this.isCatalogAtStart == null) {
            this.parseIsCatalogAtStart();
        }
        return this.isCatalogAtStart;
    }

    public boolean supportsBatchUpdates() {
        if (this.isSupportsBatchUpdates == null) {
            this.parseSupportsBatchUpdates();
        }
        return this.isSupportsBatchUpdates;
    }

    private void parseSupportsBatchUpdates() {
        this.isSupportsBatchUpdates = (Boolean)Throwables.ignoreThrowable((Logger)logger, (Object)true, (ThrowableFunction)new ThrowableFunction<Object, Boolean>(){

            public Boolean doFun(Object o) throws Throwable {
                return DatabaseDescription.this.dbMetaData.supportsBatchUpdates();
            }
        }, null);
    }
}

