/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.ddl.dump;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.io.IOs;
import com.jn.sqlhelper.common.ddl.model.Column;
import com.jn.sqlhelper.common.ddl.model.DatabaseDescription;
import com.jn.sqlhelper.common.ddl.model.ImportedColumn;
import com.jn.sqlhelper.common.ddl.model.Index;
import com.jn.sqlhelper.common.ddl.model.IndexColumn;
import com.jn.sqlhelper.common.ddl.model.PrimaryKeyColumn;
import com.jn.sqlhelper.common.ddl.model.Table;
import com.jn.sqlhelper.common.ddl.model.internal.TableType;
import com.jn.sqlhelper.common.resultset.BeanRowMapper;
import com.jn.sqlhelper.common.resultset.RowMapperResultSetExtractor;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class DatabaseLoader {
    private static final String[] tableTypes = new String[]{TableType.GLOBAL_TEMPORARY.getCode(), TableType.LOCAL_TEMPORARY.getCode(), TableType.TABLE.getCode()};

    public Table loadTable(DatabaseDescription databaseDescription, String catalog, String schema, String tableName) throws SQLException {
        return this.loadTable(databaseDescription, catalog, schema, tableName, false, false, false, false);
    }

    public Table loadTable(DatabaseDescription databaseDescription, String catalog, String schema, String tableName, boolean isLoadColumns, boolean isLoadPks, boolean isLoadIndexes, boolean isLoadFks) throws SQLException {
        List<Table> tables = this.loadTables(databaseDescription, catalog, schema, tableName, isLoadColumns, isLoadPks, isLoadIndexes, isLoadFks);
        if (Emptys.isNotEmpty(tables)) {
            return tables.get(0);
        }
        return null;
    }

    public List<Table> loadTables(DatabaseDescription databaseDescription, String catalogNamePattern, String schemaNamePattern, String tableNamePattern) throws SQLException {
        return this.loadTables(databaseDescription, catalogNamePattern, schemaNamePattern, tableNamePattern, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Table> loadTables(DatabaseDescription databaseDescription, String catalogNamePattern, String schemaNamePattern, String tableNamePattern, boolean isLoadColumns, boolean isLoadPks, boolean isLoadIndexes, boolean isLoadFks) throws SQLException {
        Object tables = null;
        ResultSet tablesRs = null;
        try {
            tablesRs = databaseDescription.getDbMetaData().getTables(catalogNamePattern, schemaNamePattern, tableNamePattern, tableTypes);
            tables = new RowMapperResultSetExtractor<Table>(new BeanRowMapper<Table>(Table.class)).extract(tablesRs);
            DatabaseMetaData dbMetaData = databaseDescription.getDbMetaData();
            Iterator iterator = tables.iterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                if (isLoadColumns) {
                    this.findColumns(dbMetaData, table);
                }
                if (isLoadPks) {
                    this.findTablePKs(dbMetaData, table);
                }
                if (isLoadIndexes) {
                    this.findTableIndexes(dbMetaData, table);
                }
                if (!isLoadFks) continue;
                this.findTableFKs(dbMetaData, table);
            }
        }
        catch (Throwable throwable) {
            IOs.close(tablesRs);
            throw throwable;
        }
        IOs.close((Object)tablesRs);
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findColumns(DatabaseMetaData dbMetaData, final Table table) throws SQLException {
        ResultSet columnsRs = null;
        try {
            columnsRs = dbMetaData.getColumns(table.getCatalog(), table.getSchema(), table.getName(), null);
            Object columns = new RowMapperResultSetExtractor<Column>(new BeanRowMapper<Column>(Column.class)).extract(columnsRs);
            Collects.forEach((Iterable)columns, (Consumer)new Consumer<Column>(){

                public void accept(Column column) {
                    table.addColumn(column);
                }
            });
        }
        catch (Throwable throwable) {
            IOs.close(columnsRs);
            throw throwable;
        }
        IOs.close((Object)columnsRs);
    }

    public List<Index> findTableIndexes(DatabaseDescription databaseDescription, String catalog, String schema, String tableNamePattern) throws SQLException {
        Table table = this.loadTable(databaseDescription, catalog, schema, tableNamePattern, false, false, true, false);
        if (table != null) {
            return Collects.asList(table.getIndexMap().values());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findTableIndexes(DatabaseMetaData dbMetaData, final Table table) throws SQLException {
        ResultSet indexesRs = null;
        try {
            indexesRs = dbMetaData.getIndexInfo(table.getCatalog(), table.getSchema(), table.getName(), false, false);
            Object indexes = new RowMapperResultSetExtractor<IndexColumn>(new BeanRowMapper<IndexColumn>(IndexColumn.class)).extract(indexesRs);
            Collects.forEach((Iterable)indexes, (Consumer)new Consumer<IndexColumn>(){

                public void accept(IndexColumn indexColumn) {
                    String indexName = indexColumn.getIndexName();
                    Index index = table.getIndex(indexName);
                    if (index == null) {
                        index = new Index(table.getCatalog(), table.getSchema(), table.getName(), indexName);
                        table.addIndex(index);
                    }
                    index.addColumn(indexColumn);
                }
            });
        }
        catch (Throwable throwable) {
            IOs.close(indexesRs);
            throw throwable;
        }
        IOs.close((Object)indexesRs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findTablePKs(DatabaseMetaData dbMetaData, Table table) throws SQLException {
        ResultSet pkRs = null;
        try {
            pkRs = dbMetaData.getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName());
            Object pkColumns = new RowMapperResultSetExtractor<PrimaryKeyColumn>(new BeanRowMapper<PrimaryKeyColumn>(PrimaryKeyColumn.class)).extract(pkRs);
            Iterator iterator = pkColumns.iterator();
            while (iterator.hasNext()) {
                PrimaryKeyColumn pk = (PrimaryKeyColumn)iterator.next();
                table.addPKColumn(pk);
            }
        }
        catch (Throwable throwable) {
            IOs.close(pkRs);
            throw throwable;
        }
        IOs.close((Object)pkRs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findTableFKs(DatabaseMetaData dbMetaData, Table table) throws SQLException {
        ResultSet fkRs = null;
        try {
            fkRs = dbMetaData.getImportedKeys(table.getCatalog(), table.getSchema(), table.getName());
            Object fkColumns = new RowMapperResultSetExtractor<ImportedColumn>(new BeanRowMapper<ImportedColumn>(ImportedColumn.class)).extract(fkRs);
            Iterator iterator = fkColumns.iterator();
            while (iterator.hasNext()) {
                ImportedColumn fk = (ImportedColumn)iterator.next();
                table.addFKColumn(fk);
            }
        }
        catch (Throwable throwable) {
            IOs.close(fkRs);
            throw throwable;
        }
        IOs.close((Object)fkRs);
    }
}

