/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.connection;

import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class ConnectionConfiguration
implements Cloneable {
    public static final String URL = "jdbc.url";
    public static final String USER = "jdbc.user";
    public static final String PASSWORD = "jdbc.password";
    public static final String DRIVER = "jdbc.driver";
    private String url;
    private String user;
    private String password;
    private String driver;
    private Properties driverProps = new Properties();

    public ConnectionConfiguration() {
    }

    public ConnectionConfiguration(String driver, String url, String user, String password, Properties driverProps) {
        if (driverProps != null) {
            this.setDriverProps(driverProps);
        }
        this.setDriver(driver);
        this.setUrl(url);
        this.setUser(user);
        this.setPassword(password);
    }

    public static ConnectionConfiguration loadConfig(InputStream input) throws IOException {
        Properties props = new Properties();
        props.load(input);
        ConnectionConfiguration config = new ConnectionConfiguration();
        config.setDriverProps(props);
        config.setUrl(props.getProperty(URL));
        config.setDriver(props.getProperty(DRIVER));
        String user = props.getProperty(USER);
        String password = props.getProperty(PASSWORD);
        config.setUser(user);
        config.setPassword(password);
        props.setProperty("user", user);
        props.setProperty("password", password);
        props.remove(URL);
        props.remove(DRIVER);
        return config;
    }

    public Object clone() throws CloneNotSupportedException {
        ConnectionConfiguration conn = new ConnectionConfiguration();
        final Properties props = new Properties();
        Collects.forEach((Map)this.driverProps, (Consumer2)new Consumer2<Object, Object>(){

            public void accept(Object key, Object value) {
                props.setProperty(key.toString(), value.toString());
            }
        });
        conn.setDriverProps(props);
        conn.setDriver(this.driver);
        conn.setUrl(this.url);
        conn.setUser(this.user);
        conn.setPassword(this.password);
        return conn;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        this.driverProps.setProperty(USER, user);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.driverProps.setProperty(PASSWORD, password);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public Properties getDriverProps() {
        return this.driverProps;
    }

    public void setDriverProps(Properties driverProps) {
        this.driverProps = driverProps;
    }
}

