/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.batch.jdbc;

import com.jn.langx.util.Preconditions;
import com.jn.sqlhelper.common.batch.BatchMode;
import com.jn.sqlhelper.common.batch.BatchResult;
import com.jn.sqlhelper.common.batch.BatchStatement;
import com.jn.sqlhelper.common.batch.BatchUpdater;
import com.jn.sqlhelper.common.statement.PreparedStatementSetter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class JdbcBatchUpdater<E, STATEMENT extends BatchStatement>
implements BatchUpdater<E, STATEMENT> {
    Connection connection;
    PreparedStatementSetter<E> setter;

    @Override
    public BatchResult<E> batchUpdate(STATEMENT statement, List<E> parametersList) throws SQLException {
        Preconditions.checkNotNull(statement);
        Preconditions.checkArgument((statement.getBatchMode() == BatchMode.JDBC_BATCH ? 1 : 0) != 0);
        PreparedStatement pstmt = this.connection.prepareStatement(statement.getSql());
        for (int i = 0; i < parametersList.size(); ++i) {
            this.setter.setParameters(pstmt, 1, parametersList.get(i));
            pstmt.addBatch();
        }
        int[] updateds = pstmt.executeBatch();
        BatchResult<E> result = new BatchResult<E>();
        result.setParameters(parametersList);
        result.setStatement((BatchStatement)statement);
        result.setRowsAffected(updateds[0]);
        return result;
    }
}

