/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.util;

import org.xmind.core.IIdentifiable;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;

public class HyperlinkUtils {
    private HyperlinkUtils() {
    }

    public static String getProtocolName(String uri) {
        int i = uri.indexOf(58);
        return i < 0 ? null : uri.substring(0, i);
    }

    public static String trimURLContent(String uri) {
        int i = uri.indexOf(58);
        if (i >= 0) {
            uri = uri.substring(i + 1);
            while (uri.startsWith("/")) {
                uri = uri.substring(1);
            }
        }
        return uri;
    }

    public static String getAttachmentProtocolName() {
        return "xap";
    }

    public static boolean isAttachmentURL(String url) {
        if (url == null || "".equals(url)) {
            return false;
        }
        return HyperlinkUtils.getAttachmentProtocolName().equals(HyperlinkUtils.getProtocolName(url));
    }

    public static String toAttachmentURL(String path) {
        return HyperlinkUtils.getAttachmentProtocolName() + ":" + path;
    }

    public static String toAttachmentPath(String url) {
        return HyperlinkUtils.trimURLContent(url);
    }

    public static String getInternalProtocolName() {
        return "xmind";
    }

    public static boolean isInternalURL(String url) {
        if (url == null || "".equals(url)) {
            return false;
        }
        return HyperlinkUtils.getInternalProtocolName().equals(HyperlinkUtils.getProtocolName(url));
    }

    public static String toInternalURL(String elementId) {
        return HyperlinkUtils.getInternalProtocolName() + ":#" + elementId;
    }

    public static String toInternalURL(Object element) {
        return HyperlinkUtils.toInternalURL(element, null);
    }

    public static String toInternalURL(Object element, IWorkbook workbook) {
        if (element instanceof IIdentifiable) {
            String id = ((IIdentifiable)element).getId();
            return HyperlinkUtils.getInternalProtocolName() + ":#" + id;
        }
        return null;
    }

    public static String toElementID(String uri) {
        int index;
        if (HyperlinkUtils.isInternalURL(uri) && (index = uri.indexOf("#")) >= 0) {
            return uri.substring(index + 1);
        }
        return null;
    }

    public static Object findElement(String uri, IWorkbook workbook) {
        String id = HyperlinkUtils.toElementID(uri);
        if (id != null) {
            Object element = workbook.getElementById(id);
            if (element instanceof ITopic && !HyperlinkUtils.isAttach((ITopic)element)) {
                element = null;
            }
            return element;
        }
        return null;
    }

    private static boolean isAttach(ITopic topic) {
        return topic.getPath().getWorkbook() == topic.getOwnedWorkbook();
    }
}

