/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;

public class ByteArrayStorage
implements IStorage {
    private static Collection<String> NO_ENTRIES = Collections.emptyList();
    private Map<String, byte[]> dataTable;
    private Map<String, Long> timeTable;

    public String getFullPath() {
        return this.getName();
    }

    public IInputSource getInputSource() {
        return new ByteArrayInputSource();
    }

    public String getName() {
        return this.toString();
    }

    public IOutputTarget getOutputTarget() {
        return new ByteArrayOutputTarget();
    }

    public void clear() {
        this.dataTable = null;
        this.timeTable = null;
    }

    protected class ByteArrayOutputTarget
    implements IOutputTarget {
        protected ByteArrayOutputTarget() {
        }

        public OutputStream getEntryStream(String entryName) {
            return new ByteArrayOutputStream2(entryName);
        }

        public OutputStream openEntryStream(String entryName) throws IOException {
            return new ByteArrayOutputStream2(entryName);
        }

        public boolean isEntryAvaialble(String entryName) {
            return entryName != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEntryTime(String entryName, long time) {
            ByteArrayOutputTarget byteArrayOutputTarget = this;
            synchronized (byteArrayOutputTarget) {
                if (ByteArrayStorage.this.timeTable == null) {
                    ByteArrayStorage.this.timeTable = new HashMap();
                }
                ByteArrayStorage.this.timeTable.put(entryName, time);
            }
        }

        private class ByteArrayOutputStream2
        extends ByteArrayOutputStream {
            private String entryName;

            public ByteArrayOutputStream2(String entryName) {
                this.entryName = entryName;
            }

            public void flush() throws IOException {
                super.flush();
                this.pushBytes();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                super.close();
                this.pushBytes();
                ByteArrayOutputTarget byteArrayOutputTarget = ByteArrayOutputTarget.this;
                synchronized (byteArrayOutputTarget) {
                    if (ByteArrayStorage.this.timeTable == null || !ByteArrayStorage.this.timeTable.containsKey(this.entryName)) {
                        ByteArrayOutputTarget.this.setEntryTime(this.entryName, System.currentTimeMillis());
                    }
                }
            }

            private void pushBytes() {
                if (ByteArrayStorage.this.dataTable == null) {
                    ByteArrayStorage.this.dataTable = new HashMap();
                }
                ByteArrayStorage.this.dataTable.put(this.entryName, this.toByteArray());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ByteArrayInputSource
    implements IInputSource {
        protected ByteArrayInputSource() {
        }

        @Override
        public Iterator<String> getEntries() {
            return ByteArrayStorage.this.dataTable == null ? NO_ENTRIES.iterator() : ByteArrayStorage.this.dataTable.keySet().iterator();
        }

        @Override
        public boolean isEntryAvailable(String entryName) {
            return ByteArrayStorage.this.dataTable.get(entryName) != null;
        }

        @Override
        public InputStream getEntryStream(String entryName) {
            byte[] bs;
            if (ByteArrayStorage.this.dataTable != null && entryName != null && (bs = (byte[])ByteArrayStorage.this.dataTable.get(entryName)) != null) {
                return new ByteArrayInputStream(bs);
            }
            return null;
        }

        @Override
        public InputStream openEntryStream(String entryName) throws IOException {
            InputStream stream = this.getEntryStream(entryName);
            if (stream == null) {
                throw new FileNotFoundException(entryName);
            }
            return stream;
        }

        @Override
        public long getEntrySize(String entryName) {
            byte[] bs;
            if (ByteArrayStorage.this.dataTable != null && entryName != null && (bs = (byte[])ByteArrayStorage.this.dataTable.get(entryName)) != null) {
                return bs.length;
            }
            return -1L;
        }

        @Override
        public long getEntryTime(String entryName) {
            Long time;
            if (ByteArrayStorage.this.timeTable != null && entryName != null && (time = (Long)ByteArrayStorage.this.timeTable.get(entryName)) != null) {
                return time;
            }
            return 0L;
        }

        @Override
        public boolean hasEntry(String entryName) {
            return ByteArrayStorage.this.dataTable != null && ByteArrayStorage.this.dataTable.containsKey(entryName);
        }
    }
}

