/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.xmind.core.CoreException;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.IMeta;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.zip.AbstractArchivedWorkbook;
import org.xmind.core.internal.zip.IArchivedWorkbook;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;

public class TempArchivedWorkbook
extends AbstractArchivedWorkbook {
    private static final List<String> IGNORE_LIST = Arrays.asList("content.xml", "markers/markerSheet.xml", "styles.xml", "META-INF/manifest.xml", "meta.xml");

    public TempArchivedWorkbook(IWorkbook workbook, String file) {
        super(workbook, file);
    }

    public InputStream getEntryInputStream(String entryPath) {
        File entryFile = new File(this.getFile(), entryPath);
        try {
            return new FileInputStream(entryFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public OutputStream getEntryOutputStream(String entryPath) {
        File entryFile = FileUtils.ensureFileParent(new File(this.getFile(), entryPath));
        try {
            return new FileOutputStream(entryFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public long getTime(String entryPath) {
        File entryFile = new File(this.getFile(), entryPath);
        if (entryFile.exists()) {
            return entryFile.lastModified();
        }
        return -1L;
    }

    public void setTime(String entryPath, long time) {
        if (time < 0L) {
            return;
        }
        File entryFile = new File(this.getFile(), entryPath);
        if (entryFile.exists()) {
            entryFile.setLastModified(time);
        }
    }

    public long getSize(String entryPath) {
        long length;
        File entryFile = new File(this.getFile(), entryPath);
        if (entryFile.exists() && (length = entryFile.length()) > 0L) {
            return length;
        }
        return -1L;
    }

    public void save(IArchivedWorkbook source) throws IOException, CoreException {
        IStyleSheet styleSheet;
        DOMUtils.save(this.workbook, this.getEntryOutputStream("content.xml"), true);
        IMarkerSheet markerSheet = this.workbook.getMarkerSheet();
        if (!markerSheet.isEmpty()) {
            DOMUtils.save(markerSheet, this.getEntryOutputStream("markers/markerSheet.xml"), true);
        }
        if (!(styleSheet = this.workbook.getStyleSheet()).isEmpty()) {
            DOMUtils.save(styleSheet, this.getEntryOutputStream("styles.xml"), true);
        }
        IMeta meta = this.workbook.getMeta();
        DOMUtils.save(meta, this.getEntryOutputStream("meta.xml"), true);
        IManifest manifest = this.workbook.getManifest();
        DOMUtils.save(manifest, this.getEntryOutputStream("META-INF/manifest.xml"), true);
        if (source != null && !this.equals(source)) {
            for (IFileEntry entry : manifest.getFileEntries()) {
                OutputStream os;
                InputStream is;
                String path = entry.getPath();
                if (IGNORE_LIST.contains(path) || entry.isDirectory() || (is = source.getEntryInputStream(path)) == null || (os = this.getEntryOutputStream(path)) == null) continue;
                try {
                    FileUtils.transfer(is, os);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.setTime(path, source.getTime(path));
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TempArchivedWorkbook)) {
            return false;
        }
        TempArchivedWorkbook that = (TempArchivedWorkbook)obj;
        return new File(this.getFile()).equals(new File(that.getFile()));
    }
}

