/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IParagraph;
import org.xmind.core.ISpan;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.HtmlNotesContentImpl;
import org.xmind.core.internal.dom.SpanImplBase;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParagraphImpl
implements IParagraph {
    private Element implementation;
    private HtmlNotesContentImpl owner;

    public ParagraphImpl(Element implementation, HtmlNotesContentImpl owner) {
        this.implementation = implementation;
        this.owner = owner;
    }

    @Override
    public String getStyleType() {
        return "paragraph";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ParagraphImpl)) {
            return false;
        }
        ParagraphImpl that = (ParagraphImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return this.implementation.toString();
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public HtmlNotesContentImpl getOwner() {
        return this.owner;
    }

    @Override
    public void addSpan(ISpan span) {
        SpanImplBase s = (SpanImplBase)span;
        this.implementation.appendChild(s.getImplementation());
        s.addNotify(this.owner.getRealizedWorkbook());
        this.getOwner().updateModifiedTime();
    }

    @Override
    public List<ISpan> getSpans() {
        return DOMUtils.getChildren(this.implementation, this.owner);
    }

    @Override
    public void removeSpan(ISpan span) {
        SpanImplBase s = (SpanImplBase)span;
        s.removeNotify(this.owner.getRealizedWorkbook());
        this.implementation.removeChild(s.getImplementation());
        this.getOwner().updateModifiedTime();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.implementation;
        }
        return null;
    }

    @Override
    public String getStyleId() {
        return DOMUtils.getAttribute(this.implementation, "style-id");
    }

    @Override
    public void setStyleId(String styleId) {
        WorkbookImpl workbook = this.owner.getRealizedWorkbook();
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
        DOMUtils.setAttribute(this.implementation, "style-id", styleId);
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
        this.getOwner().updateModifiedTime();
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.owner.getOwnedWorkbook();
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    protected void addNotify(WorkbookImpl workbook) {
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
        for (ISpan span : this.getSpans()) {
            ((SpanImplBase)span).addNotify(workbook);
        }
    }

    protected void removeNotify(WorkbookImpl workbook) {
        for (ISpan span : this.getSpans()) {
            ((SpanImplBase)span).removeNotify(workbook);
        }
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
    }
}

