/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IFileEntry;
import org.xmind.core.IFileEntryFilter;
import org.xmind.core.IManifest;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.FileEntry;
import org.xmind.core.internal.dom.EncryptionDataImpl;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.security.Crypto;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEntryImpl
extends FileEntry {
    private Element implementation;
    private ManifestImpl ownedManifest;
    private Integer refCount = null;
    private EncryptionDataImpl encData;
    private boolean ignoreEncryption = false;

    public FileEntryImpl(Element implementation, ManifestImpl ownedManifest) {
        this.implementation = implementation;
        this.ownedManifest = ownedManifest;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    @Override
    public String getMediaType() {
        return this.implementation.getAttribute("media-type");
    }

    public IManifest getOwnedManifest() {
        return this.ownedManifest;
    }

    @Override
    public String getPath() {
        return this.implementation.getAttribute("full-path");
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.implementation;
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FileEntryImpl)) {
            return false;
        }
        FileEntryImpl that = (FileEntryImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.implementation);
    }

    @Override
    public int getReferenceCount() {
        return this.refCount == null ? 0 : this.refCount;
    }

    @Override
    public boolean hasBeenReferred() {
        return this.refCount != null;
    }

    @Override
    public void increaseReference() {
        IFileEntry parentEntry;
        String parent;
        int c = this.getReferenceCount();
        this.refCount = c + 1;
        if (c <= 0) {
            this.ownedManifest.insertFileEntry(this);
        }
        if ((parent = InternalDOMUtils.getParentPath(this.getPath())) != null && (parentEntry = this.ownedManifest.getFileEntry(parent)) != null) {
            parentEntry.increaseReference();
        }
    }

    @Override
    public void decreaseReference() {
        IFileEntry parentEntry;
        String parent;
        if (this.refCount == null) {
            return;
        }
        int c = this.refCount;
        this.refCount = --c;
        if (c <= 0) {
            this.ownedManifest.removeFileEntry(this);
        }
        if ((parent = InternalDOMUtils.getParentPath(this.getPath())) != null && (parentEntry = this.ownedManifest.getFileEntry(parent)) != null) {
            parentEntry.decreaseReference();
        }
    }

    private IStorage getStorage() {
        IWorkbook wb = this.ownedManifest.getOwnedWorkbook();
        if (wb != null) {
            return wb.getTempStorage();
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        if (this.isDirectory()) {
            return null;
        }
        IStorage storage = this.getStorage();
        if (storage != null) {
            String path = this.getPath();
            return storage.getInputSource().getEntryStream(path);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.isDirectory()) {
            return null;
        }
        IStorage storage = this.getStorage();
        if (storage != null) {
            return storage.getOutputTarget().getEntryStream(this.getPath());
        }
        return null;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.isDirectory()) {
            throw new FileNotFoundException(this.getPath());
        }
        IStorage storage = this.getStorage();
        if (storage == null) {
            throw new FileNotFoundException(this.getPath());
        }
        return storage.getInputSource().openEntryStream(this.getPath());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        if (this.isDirectory()) {
            throw new FileNotFoundException(this.getPath());
        }
        IStorage storage = this.getStorage();
        if (storage == null) {
            throw new FileNotFoundException(this.getPath());
        }
        return storage.getOutputTarget().openEntryStream(this.getPath());
    }

    @Override
    public long getTime() {
        IStorage storage = this.getStorage();
        if (storage != null) {
            return storage.getInputSource().getEntryTime(this.getPath());
        }
        return -1L;
    }

    @Override
    public void setTime(long time) {
        IStorage storage = this.getStorage();
        if (storage != null) {
            storage.getOutputTarget().setEntryTime(this.getPath(), time);
        }
    }

    @Override
    public Iterator<IFileEntry> iterSubEntries() {
        final String parentPath = this.getPath();
        return this.ownedManifest.iterFileEntries(new IFileEntryFilter(){

            public boolean select(String path, String mediaType, boolean isDirectory) {
                return path.length() > parentPath.length() && path.startsWith(parentPath);
            }
        });
    }

    @Override
    public boolean isDirectory() {
        return this.getPath().endsWith("/");
    }

    @Override
    public long getSize() {
        IStorage storage = this.getStorage();
        if (storage != null) {
            return storage.getInputSource().getEntrySize(this.getPath());
        }
        return -1L;
    }

    @Override
    public IEncryptionData getEncryptionData() {
        Element encEle = DOMUtils.getFirstChildElementByTag(this.implementation, "encryption-data");
        if (encEle == null) {
            if (this.encData != null) {
                this.encData = null;
            }
        } else if (this.encData == null) {
            this.encData = new EncryptionDataImpl(encEle, this);
        }
        return this.encData;
    }

    @Override
    public IEncryptionData createEncryptionData() {
        IEncryptionData ed = this.getEncryptionData();
        if (ed != null) {
            return ed;
        }
        Element encEle = DOMUtils.createElement(this.implementation, "encryption-data");
        this.encData = new EncryptionDataImpl(encEle, this);
        Crypto.initEncryptionData(this.encData);
        return this.encData;
    }

    @Override
    public void deleteEncryptionData() {
        if (this.encData != null) {
            Element encEle = this.encData.getImplementation();
            if (encEle != null && encEle.getParentNode() == this.implementation) {
                this.implementation.removeChild(encEle);
            }
            this.encData = null;
        }
    }

    public void setIgnoreEncryption(boolean ignoreEncryption) {
        this.ignoreEncryption = ignoreEncryption;
    }

    public boolean isIgnoreEncryption() {
        return this.ignoreEncryption;
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedManifest.getOwnedWorkbook();
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.getImplementation());
    }
}

