/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

public abstract class BaseNotesContentImpl
implements INotesContent {
    private Element implementation;
    private WorkbookImpl ownedWorkbook;

    public BaseNotesContentImpl(Element implementation, WorkbookImpl ownedWorkbook) {
        this.implementation = implementation;
        this.ownedWorkbook = ownedWorkbook;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.implementation;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BaseNotesContentImpl)) {
            return false;
        }
        BaseNotesContentImpl that = (BaseNotesContentImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return this.implementation.toString();
    }

    public Element getImplementation() {
        return this.implementation;
    }

    protected WorkbookImpl getWorkbook() {
        TopicImpl topic = this.getTopic();
        if (topic != null) {
            return (WorkbookImpl)topic.getPath().getWorkbook();
        }
        return null;
    }

    protected TopicImpl getTopic() {
        INotes notes = this.getParent();
        if (notes != null) {
            return (TopicImpl)notes.getParent();
        }
        return null;
    }

    public String getFormat() {
        return this.implementation.getTagName();
    }

    public INotes getParent() {
        ITopic topic;
        Node t;
        Node p = this.implementation.getParentNode();
        if (DOMUtils.isElementByTag(p, "notes") && DOMUtils.isElementByTag(t = p.getParentNode(), "topic") && (topic = (ITopic)this.ownedWorkbook.getAdaptableRegistry().getAdaptable(t)) != null) {
            return topic.getNotes();
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    protected abstract void addNotify(WorkbookImpl var1);

    protected abstract void removeNotify(WorkbookImpl var1);

    protected void updateModifiedTime() {
        TopicImpl topic = this.getTopic();
        if (topic != null) {
            topic.updateModifiedTime();
        }
    }
}

