/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UrlUtils {
    private static Map<String, String> ENTITIES = new HashMap<String, String>();
    private static Pattern PATTERN;

    UrlUtils() {
    }

    static String escapeXml(String string) {
        Matcher matcher = PATTERN.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, ENTITIES.get(matcher.group(1)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static void checkUrl(URL url, URL baseUrl) {
        if (baseUrl.getHost() == null) {
            throw new RuntimeException("base URL is null");
        }
        if (!baseUrl.getHost().equalsIgnoreCase(url.getHost())) {
            throw new RuntimeException("Domain of URL " + url + " doesn't match base URL " + baseUrl);
        }
    }

    static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    static {
        ENTITIES.put("&", "&amp;");
        ENTITIES.put("'", "&apos;");
        ENTITIES.put("\"", "&quot;");
        ENTITIES.put(">", "&gt;");
        ENTITIES.put("<", "&lt;");
        PATTERN = Pattern.compile("(&|'|\"|>|<)");
    }
}

