/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSource;
import cn.beecp.BeeDataSourceConfig;
import cn.beecp.jta.BeeJtaDataSource;
import cn.beecp.pool.PoolStaticCenter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeeDataSourceFactory
implements ObjectFactory {
    private static String getConfigValue(Reference ref, String propertyName) {
        String value = BeeDataSourceFactory.readConfig(ref, propertyName);
        if (value != null) {
            return value;
        }
        String newPropertyName = propertyName.substring(0, 1).toLowerCase(Locale.US) + propertyName.substring(1);
        value = BeeDataSourceFactory.readConfig(ref, newPropertyName);
        if (value != null) {
            return value;
        }
        value = BeeDataSourceFactory.readConfig(ref, PoolStaticCenter.propertyNameToFieldId(newPropertyName, "-"));
        if (value != null) {
            return value;
        }
        return BeeDataSourceFactory.readConfig(ref, PoolStaticCenter.propertyNameToFieldId(newPropertyName, "_"));
    }

    private static String readConfig(Reference ref, String propertyName) {
        RefAddr refAddr = ref.get(propertyName);
        if (refAddr != null) {
            Object refObject = refAddr.getContent();
            if (refObject == null) {
                return null;
            }
            String value = refObject.toString().trim();
            if (!PoolStaticCenter.isBlank(value)) {
                PoolStaticCenter.CommonLog.info("beecp.{}={}", (Object)propertyName, (Object)value);
                return value;
            }
        }
        return null;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        TransactionManager tm = null;
        String tmJndiName = BeeDataSourceFactory.getConfigValue(ref, "transactionManagerName");
        if (!PoolStaticCenter.isBlank(tmJndiName) && nameCtx != null) {
            tm = (TransactionManager)nameCtx.lookup(tmJndiName);
        }
        BeeDataSourceConfig config = new BeeDataSourceConfig();
        Map<String, Method> setMethodMap = PoolStaticCenter.getClassSetMethodMap(config.getClass());
        HashMap<String, Object> setValueMap = new HashMap<String, Object>(setMethodMap.size());
        for (String propertyName : setMethodMap.keySet()) {
            String configVal = BeeDataSourceFactory.getConfigValue(ref, propertyName);
            if (PoolStaticCenter.isBlank(configVal)) continue;
            setValueMap.put(propertyName, configVal);
        }
        PoolStaticCenter.setPropertiesValue(config, setMethodMap, setValueMap);
        config.addConnectProperty(BeeDataSourceFactory.getConfigValue(ref, "connectProperties"));
        String connectPropertiesCount = BeeDataSourceFactory.getConfigValue(ref, "connectProperties.size");
        if (!PoolStaticCenter.isBlank(connectPropertiesCount)) {
            int count = Integer.parseInt(connectPropertiesCount.trim());
            for (int i = 1; i <= count; ++i) {
                config.addConnectProperty(BeeDataSourceFactory.getConfigValue(ref, "connectProperties." + i));
            }
        }
        BeeDataSource ds = new BeeDataSource(config);
        return tm != null ? new BeeJtaDataSource(ds, tm) : ds;
    }
}

