/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;

public abstract class ProxyConnectionBase
implements Connection {
    protected Connection delegate;
    protected PooledConnection pCon;
    private boolean isClosed;

    public ProxyConnectionBase(PooledConnection pCon) {
        this.pCon = pCon;
        pCon.proxyCon = this;
        this.delegate = pCon.rawCon;
    }

    final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw PoolStaticCenter.ConnectionClosedException;
        }
    }

    public Connection getDelegate() throws SQLException {
        this.checkClosed();
        return this.delegate;
    }

    final synchronized void registerStatement(ProxyStatementBase s) {
        this.pCon.registerStatement(s);
    }

    final synchronized void unregisterStatement(ProxyStatementBase s) {
        this.pCon.unregisterStatement(s);
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        ProxyConnectionBase proxyConnectionBase = this;
        synchronized (proxyConnectionBase) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.delegate = PoolStaticCenter.CLOSED_CON;
            if (this.pCon.openStmSize > 0) {
                this.pCon.clearStatement();
            }
        }
        this.pCon.recycleSelf();
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.pCon.commitDirtyInd) {
            throw PoolStaticCenter.AutoCommitChangeForbiddenException;
        }
        this.delegate.setAutoCommit(autoCommit);
        this.pCon.curAutoCommit = autoCommit;
        this.pCon.setResetInd(0, autoCommit != this.pCon.cfgAutoCommit);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
        this.pCon.setResetInd(1, level != this.pCon.cfgTransactionIsolationCode);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
        this.pCon.setResetInd(2, readOnly != this.pCon.cfgReadOnly);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
        this.pCon.setResetInd(3, !PoolStaticCenter.equals(catalog, this.pCon.cfgCatalog));
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.delegate.setSchema(schema);
        this.pCon.setResetInd(4, !PoolStaticCenter.equals(schema, this.pCon.cfgSchema));
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("executor can't be null");
        }
        executor.execute(new ProxyConnectionCloseTask(this));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (!this.pCon.supportNetworkTimeout()) {
            throw PoolStaticCenter.DriverNotSupportNetworkTimeoutException;
        }
        this.delegate.setNetworkTimeout(executor, milliseconds);
        this.pCon.setResetInd(5, milliseconds != this.pCon.cfgNetworkTimeout);
    }

    @Override
    public void commit() throws SQLException {
        this.delegate.commit();
        this.pCon.lastAccessTime = System.currentTimeMillis();
        this.pCon.commitDirtyInd = false;
    }

    @Override
    public void rollback() throws SQLException {
        this.delegate.rollback();
        this.pCon.lastAccessTime = System.currentTimeMillis();
        this.pCon.commitDirtyInd = false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }

    private static final class ProxyConnectionCloseTask
    implements Runnable {
        private ProxyConnectionBase proxyCon;

        public ProxyConnectionCloseTask(ProxyConnectionBase proxyCon) {
            this.proxyCon = proxyCon;
        }

        @Override
        public void run() {
            try {
                this.proxyCon.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

