/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.pool.FastConnectionPool;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ThreadPoolExecutor;

class PooledConnection {
    private static final boolean[] FALSE_ARRAY = new boolean[6];
    final boolean cfgAutoCommit;
    final int cfgTransactionIsolationCode;
    final boolean cfgReadOnly;
    final String cfgCatalog;
    final String cfgSchema;
    final int cfgNetworkTimeout;
    private final ThreadPoolExecutor networkTimeoutExecutor;
    private final FastConnectionPool pool;
    private final boolean[] resetInd = new boolean[FALSE_ARRAY.length];
    volatile int state;
    Connection rawCon;
    ProxyConnectionBase proxyCon;
    volatile long lastAccessTime;
    boolean commitDirtyInd;
    boolean curAutoCommit;
    int openStmSize;
    private int resetCnt;
    private ProxyStatementBase[] openStatements;

    public PooledConnection(Connection rawConn, int connState, FastConnectionPool connPool, BeeDataSourceConfig config) {
        this.pool = connPool;
        this.state = connState;
        this.rawCon = rawConn;
        this.cfgTransactionIsolationCode = config.getDefaultTransactionIsolationCode();
        this.cfgReadOnly = config.isDefaultReadOnly();
        this.cfgCatalog = config.getDefaultCatalog();
        this.cfgSchema = config.getDefaultSchema();
        this.cfgNetworkTimeout = this.pool.getNetworkTimeout();
        this.networkTimeoutExecutor = this.pool.getNetworkTimeoutExecutor();
        this.curAutoCommit = this.cfgAutoCommit = config.isDefaultAutoCommit();
        this.openStatements = new ProxyStatementBase[10];
        this.lastAccessTime = System.currentTimeMillis();
    }

    final void onBeforeRemove() {
        try {
            this.state = 3;
            this.resetRawConn();
        }
        catch (Throwable e) {
            PoolStaticCenter.commonLog.error("Connection close error", e);
        }
        finally {
            PoolStaticCenter.oclose(this.rawCon);
        }
    }

    final void recycleSelf() throws SQLException {
        try {
            this.proxyCon = null;
            this.resetRawConn();
            this.pool.recycle(this);
        }
        catch (Throwable e) {
            this.pool.abandonOnReturn(this);
            throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
        }
    }

    final void updateAccessTime() {
        this.commitDirtyInd = !this.curAutoCommit;
        this.lastAccessTime = System.currentTimeMillis();
    }

    final void setResetInd(int p, boolean chgd) {
        if (!this.resetInd[p] && chgd) {
            ++this.resetCnt;
        } else if (this.resetInd[p] && !chgd) {
            --this.resetCnt;
        }
        this.resetInd[p] = chgd;
    }

    boolean supportNetworkTimeout() {
        return this.pool.supportNetworkTimeout();
    }

    final void resetRawConn() throws SQLException {
        if (this.commitDirtyInd) {
            this.rawCon.rollback();
            this.commitDirtyInd = false;
        }
        if (this.resetCnt > 0) {
            if (this.resetInd[0]) {
                this.rawCon.setAutoCommit(this.cfgAutoCommit);
                this.curAutoCommit = this.cfgAutoCommit;
            }
            if (this.resetInd[1]) {
                this.rawCon.setTransactionIsolation(this.cfgTransactionIsolationCode);
            }
            if (this.resetInd[2]) {
                this.rawCon.setReadOnly(this.cfgReadOnly);
            }
            if (this.resetInd[3]) {
                this.rawCon.setCatalog(this.cfgCatalog);
            }
            if (this.resetInd[4]) {
                this.rawCon.setSchema(this.cfgSchema);
            }
            if (this.resetInd[5]) {
                this.rawCon.setNetworkTimeout(this.networkTimeoutExecutor, this.cfgNetworkTimeout);
            }
            this.resetCnt = 0;
            System.arraycopy(FALSE_ARRAY, 0, this.resetInd, 0, 6);
        }
        this.rawCon.clearWarnings();
    }

    final void registerStatement(ProxyStatementBase s) {
        if (this.openStmSize == this.openStatements.length) {
            ProxyStatementBase[] newArray = new ProxyStatementBase[this.openStatements.length << 1];
            System.arraycopy(this.openStatements, 0, newArray, 0, this.openStatements.length);
            this.openStatements = newArray;
        }
        this.openStatements[this.openStmSize++] = s;
    }

    final void unregisterStatement(ProxyStatementBase s) {
        for (int i = 0; i < this.openStmSize; ++i) {
            if (s != this.openStatements[i]) continue;
            int m = this.openStmSize - i - 1;
            if (m > 0) {
                System.arraycopy(this.openStatements, i + 1, this.openStatements, i, m);
            }
            this.openStatements[--this.openStmSize] = null;
            return;
        }
    }

    final void clearStatement() {
        for (int i = 0; i < this.openStmSize; ++i) {
            ProxyStatementBase s = this.openStatements[i];
            if (s == null) continue;
            this.openStatements[i] = null;
            s.registered = false;
            PoolStaticCenter.oclose(s);
        }
        this.openStmSize = 0;
    }
}

