/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.ConnectionFactory;
import cn.beecp.pool.Borrower;
import cn.beecp.pool.ConnectionPool;
import cn.beecp.pool.ConnectionPoolJmxBean;
import cn.beecp.pool.ConnectionPoolMonitorVo;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyConnectionBase;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class FastConnectionPool
extends Thread
implements ConnectionPool,
ConnectionPoolJmxBean {
    private static final long spinForTimeoutThreshold = 1000L;
    private static final int maxTimedSpins = Runtime.getRuntime().availableProcessors() < 2 ? 0 : 32;
    private static final AtomicIntegerFieldUpdater<PooledConnection> ConStUpd = AtomicIntegerFieldUpdater.newUpdater(PooledConnection.class, "state");
    private static final AtomicReferenceFieldUpdater<Borrower, Object> BorrowStUpd = AtomicReferenceFieldUpdater.newUpdater(Borrower.class, Object.class, "state");
    private static final String DESC_RM_PRE_INIT = "pre_init";
    private static final String DESC_RM_INIT = "init";
    private static final String DESC_RM_BAD = "bad";
    private static final String DESC_RM_IDLE = "idle";
    private static final String DESC_RM_CLOSED = "closed";
    private static final String DESC_RM_CLEAR = "clear";
    private static final String DESC_RM_DESTROY = "destroy";
    private static final AtomicInteger poolNameIndex = new AtomicInteger(1);
    private final Object connArrayLock = new Object();
    private final ConcurrentLinkedQueue<Borrower> waitQueue = new ConcurrentLinkedQueue();
    private final ThreadLocal<WeakReference<Borrower>> threadLocal = new ThreadLocal();
    private final ConnectionPoolMonitorVo monitorVo = new ConnectionPoolMonitorVo();
    private int PoolMaxSize;
    private long MaxWaitNanos;
    private int ConUnCatchStateCode;
    private long ConTestInterval;
    private long DelayTimeForNextClearNanos;
    private ConnectionTester conTester;
    private ConnectionPoolHook exitHook;
    private BeeDataSourceConfig poolConfig;
    private int semaphoreSize;
    private Semaphore semaphore;
    private TransferPolicy transferPolicy;
    private ConnectionFactory conFactory;
    private volatile PooledConnection[] conArray = new PooledConnection[0];
    private DynAddPooledConnTask dynAddPooledConnTask;
    private ThreadPoolExecutor poolTaskExecutor;
    private int networkTimeout;
    private boolean supportIsValidTest;
    private boolean supportNetworkTimeout = true;
    private boolean supportNetworkTimeoutTest;
    private String poolName = "";
    private String poolMode = "";
    private AtomicInteger poolState = new AtomicInteger(1);
    private AtomicInteger needAddConSize = new AtomicInteger(0);
    private AtomicInteger idleThreadState = new AtomicInteger(1);

    @Override
    public void init(BeeDataSourceConfig config) throws SQLException {
        if (this.poolState.get() == 1) {
            this.checkProxyClasses();
            if (config == null) {
                throw new SQLException("Configuration can't be null");
            }
            this.poolConfig = config.check();
            this.poolName = !PoolStaticCenter.isBlank(config.getPoolName()) ? config.getPoolName() : "FastPool-" + poolNameIndex.getAndIncrement();
            PoolStaticCenter.commonLog.info("BeeCP({})starting....", (Object)this.poolName);
            this.PoolMaxSize = this.poolConfig.getMaxActive();
            this.conFactory = this.poolConfig.getConnectionFactory();
            this.MaxWaitNanos = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getMaxWait());
            this.DelayTimeForNextClearNanos = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getDelayTimeForNextClear());
            this.ConTestInterval = this.poolConfig.getConnectionTestInterval();
            if (this.poolConfig.isFairMode()) {
                this.poolMode = "fair";
                this.transferPolicy = new FairTransferPolicy();
            } else {
                this.poolMode = "compete";
                this.transferPolicy = new CompeteTransferPolicy();
            }
        } else {
            throw new SQLException("Pool has initialized");
        }
        this.ConUnCatchStateCode = this.transferPolicy.getCheckStateCode();
        this.semaphoreSize = this.poolConfig.getBorrowSemaphoreSize();
        this.semaphore = new Semaphore(this.semaphoreSize, this.poolConfig.isFairMode());
        this.dynAddPooledConnTask = new DynAddPooledConnTask();
        this.poolTaskExecutor = new ThreadPoolExecutor(2, 2, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PoolThreadThreadFactory("PoolTaskThread"));
        this.poolTaskExecutor.allowCoreThreadTimeOut(true);
        this.createInitConnections(this.poolConfig.getInitialSize());
        this.exitHook = new ConnectionPoolHook();
        Runtime.getRuntime().addShutdownHook(this.exitHook);
        this.registerJmx();
        PoolStaticCenter.commonLog.info("BeeCP({})has startup{mode:{},init size:{},max size:{},semaphore size:{},max wait:{}ms,driver:{}}", new Object[]{this.poolName, this.poolMode, this.conArray.length, config.getMaxActive(), this.semaphoreSize, this.poolConfig.getMaxWait(), this.poolConfig.getDriverClassName()});
        this.poolState.set(2);
        this.setName("IdleTimeoutScanThread");
        this.setDaemon(true);
        this.start();
    }

    private void checkProxyClasses() throws SQLException {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            ArrayList<String> classNameList = new ArrayList<String>(10);
            classNameList.add("cn.beecp.pool.Borrower");
            classNameList.add("cn.beecp.pool.PooledConnection");
            classNameList.add("cn.beecp.pool.ProxyConnection");
            classNameList.add("cn.beecp.pool.ProxyStatement");
            classNameList.add("cn.beecp.pool.ProxyPsStatement");
            classNameList.add("cn.beecp.pool.ProxyCsStatement");
            classNameList.add("cn.beecp.pool.ProxyDatabaseMetaData");
            classNameList.add("cn.beecp.pool.ProxyResultSet");
            int l = classNameList.size();
            for (int i = 0; i < l; ++i) {
                Class.forName((String)classNameList.get(i), false, classLoader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Jdbc proxy classes missed", e);
        }
    }

    private void createInitConnections(int initSize) throws SQLException {
        try {
            int size = initSize > 0 ? initSize : 1;
            for (int i = 0; i < size; ++i) {
                this.createPooledConn(1);
            }
        }
        catch (Throwable e) {
            for (PooledConnection pCon : this.conArray) {
                this.removePooledConn(pCon, DESC_RM_INIT);
            }
            if (e instanceof PoolStaticCenter.ConnectionCreateFailedException) {
                if (initSize > 0) {
                    throw e;
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PooledConnection createPooledConn(int conState) throws SQLException {
        Object object = this.connArrayLock;
        synchronized (object) {
            int arrayLen = this.conArray.length;
            if (arrayLen < this.PoolMaxSize) {
                if (PoolStaticCenter.isDebugEnabled) {
                    PoolStaticCenter.commonLog.debug("BeeCP({}))begin to create a new pooled connection,state:{}", (Object)this.poolName, (Object)conState);
                }
                Connection con = null;
                try {
                    con = this.conFactory.create();
                }
                catch (Throwable e) {
                    throw new PoolStaticCenter.ConnectionCreateFailedException(e);
                }
                try {
                    this.setDefaultOnRawConn(con);
                }
                catch (Throwable e) {
                    PoolStaticCenter.oclose(con);
                    throw e;
                }
                PooledConnection pCon = new PooledConnection(con, conState, this, this.poolConfig);
                if (PoolStaticCenter.isDebugEnabled) {
                    PoolStaticCenter.commonLog.debug("BeeCP({}))has created a new pooled connection:{},state:{}", new Object[]{this.poolName, pCon, conState});
                }
                PooledConnection[] arrayNew = new PooledConnection[arrayLen + 1];
                System.arraycopy(this.conArray, 0, arrayNew, 0, arrayLen);
                arrayNew[arrayLen] = pCon;
                this.conArray = arrayNew;
                return pCon;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePooledConn(PooledConnection pCon, String removeType) {
        if (PoolStaticCenter.isDebugEnabled) {
            PoolStaticCenter.commonLog.debug("BeeCP({}))begin to remove pooled connection:{},reason:{}", new Object[]{this.poolName, pCon, removeType});
        }
        pCon.onBeforeRemove();
        Object object = this.connArrayLock;
        synchronized (object) {
            int oLen = this.conArray.length;
            PooledConnection[] arrayNew = new PooledConnection[oLen - 1];
            for (int i = 0; i < oLen; ++i) {
                if (this.conArray[i] != pCon) continue;
                System.arraycopy(this.conArray, 0, arrayNew, 0, i);
                int m = oLen - i - 1;
                if (m <= 0) break;
                System.arraycopy(this.conArray, i + 1, arrayNew, i, m);
                break;
            }
            if (PoolStaticCenter.isDebugEnabled) {
                PoolStaticCenter.commonLog.debug("BeeCP({}))has removed pooled connection:{},reason:{}", new Object[]{this.poolName, pCon, removeType});
            }
            this.conArray = arrayNew;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setDefaultOnRawConn(Connection rawCon) throws SQLException {
        rawCon.setAutoCommit(this.poolConfig.isDefaultAutoCommit());
        rawCon.setTransactionIsolation(this.poolConfig.getDefaultTransactionIsolationCode());
        rawCon.setReadOnly(this.poolConfig.isDefaultReadOnly());
        if (!PoolStaticCenter.isBlank(this.poolConfig.getDefaultCatalog())) {
            rawCon.setCatalog(this.poolConfig.getDefaultCatalog());
        }
        if (!PoolStaticCenter.isBlank(this.poolConfig.getDefaultSchema())) {
            rawCon.setSchema(this.poolConfig.getDefaultSchema());
        }
        if (!this.supportNetworkTimeoutTest) {
            try {
                this.networkTimeout = rawCon.getNetworkTimeout();
                if (this.networkTimeout < 0) {
                    this.supportNetworkTimeout = false;
                    PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'networkTimeout'", (Object)this.poolName);
                } else {
                    rawCon.setNetworkTimeout(this.poolTaskExecutor, this.networkTimeout);
                }
            }
            catch (Throwable e) {
                this.supportNetworkTimeout = false;
                if (PoolStaticCenter.isDebugEnabled) {
                    PoolStaticCenter.commonLog.debug("BeeCP({})driver not support 'networkTimeout',cause:", (Object)this.poolName, (Object)e);
                } else {
                    PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'networkTimeout'", (Object)this.poolName);
                }
            }
            finally {
                this.supportNetworkTimeoutTest = true;
            }
        }
        if (!this.supportIsValidTest) {
            boolean supportIsValid = true;
            try {
                if (rawCon.isValid(this.poolConfig.getConnectionTestTimeout())) {
                    this.conTester = new ConnValidTester(this.poolName, this.poolConfig.getConnectionTestTimeout());
                    return;
                }
                supportIsValid = false;
                PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'isValid'", (Object)this.poolName);
            }
            catch (Throwable e) {
                supportIsValid = false;
                if (PoolStaticCenter.isDebugEnabled) {
                    PoolStaticCenter.commonLog.debug("BeeCP({})driver not support 'isValid',cause:", (Object)this.poolName, (Object)e);
                } else {
                    PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'isValid'", (Object)this.poolName);
                }
            }
            finally {
                this.supportIsValidTest = true;
            }
            if (!supportIsValid) {
                Statement st = null;
                this.conTester = new SqlQueryTester(this.poolName, this.poolConfig.getConnectionTestTimeout(), this.poolConfig.isDefaultAutoCommit(), this.poolConfig.getConnectionTestSql());
                try {
                    st = rawCon.createStatement();
                    this.testQueryTimeout(st, this.poolConfig.getConnectionTestTimeout());
                    this.validateTestSql(rawCon, st);
                }
                finally {
                    if (st != null) {
                        PoolStaticCenter.oclose(st);
                    }
                }
            }
        }
    }

    private void testQueryTimeout(Statement st, int timeoutSeconds) {
        try {
            st.setQueryTimeout(timeoutSeconds);
        }
        catch (Throwable e) {
            ((SqlQueryTester)this.conTester).setSupportQueryTimeout(false);
            if (PoolStaticCenter.isDebugEnabled) {
                PoolStaticCenter.commonLog.debug("BeeCP({})driver not support 'queryTimeout',cause:", (Object)this.poolName, (Object)e);
            }
            PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'queryTimeout'", (Object)this.poolName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateTestSql(Connection rawCon, Statement st) throws SQLException {
        boolean changed = false;
        try {
            if (this.poolConfig.isDefaultAutoCommit()) {
                rawCon.setAutoCommit(false);
                changed = true;
            }
            st.execute(this.poolConfig.getConnectionTestSql());
        }
        catch (Throwable throwable) {
            try {
                rawCon.rollback();
                if (!changed) throw throwable;
                rawCon.setAutoCommit(this.poolConfig.isDefaultAutoCommit());
                throw throwable;
            }
            catch (Throwable e) {
                throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
            }
        }
        try {
            rawCon.rollback();
            if (!changed) return;
            rawCon.setAutoCommit(this.poolConfig.isDefaultAutoCommit());
            return;
        }
        catch (Throwable e) {
            throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
        }
    }

    private void tryToCreateNewConnByAsyn() {
        int updAddSize;
        int curAddSize;
        do {
            if (this.conArray.length + (updAddSize = (curAddSize = this.needAddConSize.get()) + 1) <= this.PoolMaxSize) continue;
            return;
        } while (!this.needAddConSize.compareAndSet(curAddSize, updAddSize));
        this.poolTaskExecutor.submit(this.dynAddPooledConnTask);
    }

    int getNetworkTimeout() {
        return this.networkTimeout;
    }

    ThreadPoolExecutor getNetworkTimeoutExecutor() {
        return this.poolTaskExecutor;
    }

    boolean supportNetworkTimeout() {
        return this.supportNetworkTimeout;
    }

    @Override
    public final Connection getConnection() throws SQLException {
        Borrower borrower;
        if (this.poolState.get() != 2) {
            throw PoolStaticCenter.PoolCloseException;
        }
        WeakReference<Borrower> ref = this.threadLocal.get();
        Borrower borrower2 = borrower = ref != null ? (Borrower)ref.get() : null;
        if (borrower != null) {
            PooledConnection pCon = borrower.lastUsedCon;
            if (pCon != null && pCon.state == 1 && ConStUpd.compareAndSet(pCon, 1, 2)) {
                if (this.testOnBorrow(pCon)) {
                    return PoolStaticCenter.createProxyConnection(pCon, borrower);
                }
                borrower.lastUsedCon = null;
            }
        } else {
            borrower = new Borrower();
            this.threadLocal.set(new WeakReference<Borrower>(borrower));
        }
        long deadlineNanos = System.nanoTime() + this.MaxWaitNanos;
        try {
            if (!this.semaphore.tryAcquire(this.MaxWaitNanos, TimeUnit.NANOSECONDS)) {
                throw PoolStaticCenter.RequestTimeoutException;
            }
        }
        catch (InterruptedException e) {
            throw PoolStaticCenter.RequestInterruptException;
        }
        try {
            int spinSize;
            PooledConnection pCon2;
            for (PooledConnection pCon2 : this.conArray) {
                if (pCon2.state != 1 || !ConStUpd.compareAndSet(pCon2, 1, 2) || !this.testOnBorrow(pCon2)) continue;
                Connection connection = PoolStaticCenter.createProxyConnection(pCon2, borrower);
                return connection;
            }
            if (this.conArray.length < this.PoolMaxSize && (pCon2 = this.createPooledConn(2)) != null) {
                Connection i = PoolStaticCenter.createProxyConnection(pCon2, borrower);
                return i;
            }
            boolean failed = false;
            SQLException cause = null;
            Thread cth = borrower.thread;
            borrower.state = PoolStaticCenter.BOWER_NORMAL;
            this.waitQueue.offer(borrower);
            int n = spinSize = this.waitQueue.peek() == borrower ? maxTimedSpins : 0;
            while (true) {
                Object state;
                if ((state = borrower.state) instanceof PooledConnection) {
                    pCon2 = (PooledConnection)state;
                    if (this.transferPolicy.tryCatch(pCon2) && this.testOnBorrow(pCon2)) {
                        this.waitQueue.remove(borrower);
                        Connection connection = PoolStaticCenter.createProxyConnection(pCon2, borrower);
                        return connection;
                    }
                } else if (state instanceof SQLException) {
                    this.waitQueue.remove(borrower);
                    throw (SQLException)state;
                }
                if (failed) {
                    if (borrower.state != state) continue;
                    BorrowStUpd.compareAndSet(borrower, state, cause);
                    continue;
                }
                if (state instanceof PooledConnection) {
                    borrower.state = PoolStaticCenter.BOWER_NORMAL;
                    FastConnectionPool.yield();
                    continue;
                }
                long timeout = deadlineNanos - System.nanoTime();
                if (timeout > 0L) {
                    if (spinSize > 0) {
                        --spinSize;
                        continue;
                    }
                    if (borrower.state != PoolStaticCenter.BOWER_NORMAL || timeout <= 1000L || !BorrowStUpd.compareAndSet(borrower, PoolStaticCenter.BOWER_NORMAL, PoolStaticCenter.BOWER_WAITING)) continue;
                    LockSupport.parkNanos(timeout);
                    if (cth.isInterrupted()) {
                        failed = true;
                        cause = PoolStaticCenter.RequestInterruptException;
                    }
                    if (borrower.state != PoolStaticCenter.BOWER_WAITING) continue;
                    BorrowStUpd.compareAndSet(borrower, PoolStaticCenter.BOWER_WAITING, failed ? cause : PoolStaticCenter.BOWER_NORMAL);
                    continue;
                }
                failed = true;
                cause = PoolStaticCenter.RequestTimeoutException;
            }
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    public final void recycle(PooledConnection pCon) {
        this.transferPolicy.beforeTransfer(pCon);
        block0: for (Borrower borrower : this.waitQueue) {
            Object state;
            do {
                if (pCon.state != this.ConUnCatchStateCode) {
                    return;
                }
                state = borrower.state;
                if (!(state instanceof PoolStaticCenter.BorrowerState)) continue block0;
            } while (!BorrowStUpd.compareAndSet(borrower, state, pCon));
            if (state == PoolStaticCenter.BOWER_WAITING) {
                LockSupport.unpark(borrower.thread);
            }
            return;
        }
        this.transferPolicy.onFailedTransfer(pCon);
    }

    private void transferException(SQLException e) {
        for (Borrower borrower : this.waitQueue) {
            Object state;
            while ((state = borrower.state) instanceof PoolStaticCenter.BorrowerState) {
                if (!BorrowStUpd.compareAndSet(borrower, state, e)) continue;
                if (state == PoolStaticCenter.BOWER_WAITING) {
                    LockSupport.unpark(borrower.thread);
                }
                return;
            }
        }
    }

    final void abandonOnReturn(PooledConnection pCon) {
        this.removePooledConn(pCon, DESC_RM_BAD);
        this.tryToCreateNewConnByAsyn();
    }

    private final boolean testOnBorrow(PooledConnection pCon) {
        if (System.currentTimeMillis() - pCon.lastAccessTime - this.ConTestInterval >= 0L && !this.conTester.isAlive(pCon)) {
            this.removePooledConn(pCon, DESC_RM_BAD);
            this.tryToCreateNewConnByAsyn();
            return false;
        }
        return true;
    }

    private final boolean existBorrower() {
        return this.semaphoreSize > this.semaphore.availablePermits();
    }

    private void shutdownIdleScanThread() {
        this.idleThreadState.set(2);
        LockSupport.unpark(this);
    }

    @Override
    public void run() {
        long CheckTimeIntervalNanos = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getIdleCheckTimeInterval());
        while (this.idleThreadState.get() == 1) {
            try {
                LockSupport.parkNanos(CheckTimeIntervalNanos);
                this.closeIdleTimeoutConnection();
            }
            catch (Throwable throwable) {}
        }
    }

    private void closeIdleTimeoutConnection() {
        if (this.poolState.get() == 2) {
            for (PooledConnection pCon : this.conArray) {
                int state = pCon.state;
                if (state == 1 && !this.existBorrower()) {
                    boolean isTimeoutInIdle;
                    boolean bl = isTimeoutInIdle = System.currentTimeMillis() - pCon.lastAccessTime - this.poolConfig.getIdleTimeout() >= 0L;
                    if (!isTimeoutInIdle || !ConStUpd.compareAndSet(pCon, state, 3)) continue;
                    this.removePooledConn(pCon, DESC_RM_IDLE);
                    this.tryToCreateNewConnByAsyn();
                    continue;
                }
                if (state == 2) {
                    if (System.currentTimeMillis() - pCon.lastAccessTime - this.poolConfig.getHoldTimeout() < 0L) continue;
                    ProxyConnectionBase proxyConn = pCon.proxyCon;
                    if (proxyConn != null) {
                        PoolStaticCenter.oclose(proxyConn);
                        continue;
                    }
                    this.removePooledConn(pCon, DESC_RM_BAD);
                    this.tryToCreateNewConnByAsyn();
                    continue;
                }
                if (state != 3) continue;
                this.removePooledConn(pCon, DESC_RM_CLOSED);
                this.tryToCreateNewConnByAsyn();
            }
            ConnectionPoolMonitorVo vo = this.getMonitorVo();
            if (PoolStaticCenter.isDebugEnabled) {
                PoolStaticCenter.commonLog.debug("BeeCP({})idle:{},using:{},semaphore-waiter:{},wait-transfer:{}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaiterSize(), vo.getTransferWaiterSize()});
            }
        }
    }

    @Override
    public void clearAllConnections() {
        this.clearAllConnections(false);
    }

    @Override
    public void clearAllConnections(boolean force) {
        if (this.poolState.compareAndSet(2, 4)) {
            PoolStaticCenter.commonLog.info("BeeCP({})begin to remove connections", (Object)this.poolName);
            this.removeAllConnections(force, DESC_RM_CLEAR);
            PoolStaticCenter.commonLog.info("BeeCP({})all connections were removed", (Object)this.poolName);
            this.poolState.set(2);
            PoolStaticCenter.commonLog.info("BeeCP({})restore to accept new requests", (Object)this.poolName);
        }
    }

    private void removeAllConnections(boolean force, String source) {
        while (this.existBorrower()) {
            this.transferException(PoolStaticCenter.PoolCloseException);
        }
        while (this.conArray.length > 0) {
            for (PooledConnection pCon : this.conArray) {
                if (ConStUpd.compareAndSet(pCon, 1, 3)) {
                    this.removePooledConn(pCon, source);
                    continue;
                }
                if (pCon.state == 3) {
                    this.removePooledConn(pCon, source);
                    continue;
                }
                if (pCon.state != 2) continue;
                ProxyConnectionBase proxyConn = pCon.proxyCon;
                if (proxyConn != null) {
                    if (!force && System.currentTimeMillis() - pCon.lastAccessTime - this.poolConfig.getHoldTimeout() < 0L) continue;
                    PoolStaticCenter.oclose(proxyConn);
                    continue;
                }
                this.removePooledConn(pCon, source);
            }
            if (this.conArray.length <= 0) continue;
            LockSupport.parkNanos(this.DelayTimeForNextClearNanos);
        }
    }

    @Override
    public boolean isClosed() {
        return this.poolState.get() == 3;
    }

    @Override
    public void close() throws SQLException {
        while (true) {
            int poolStateCode;
            if (((poolStateCode = this.poolState.get()) == 1 || poolStateCode == 2) && this.poolState.compareAndSet(poolStateCode, 3)) {
                PoolStaticCenter.commonLog.info("BeeCP({})begin to shutdown", (Object)this.poolName);
                this.removeAllConnections(this.poolConfig.isForceCloseUsingOnClear(), DESC_RM_DESTROY);
                this.unregisterJmx();
                this.shutdownIdleScanThread();
                this.poolTaskExecutor.getQueue().clear();
                this.poolTaskExecutor.shutdownNow();
                try {
                    Runtime.getRuntime().removeShutdownHook(this.exitHook);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                PoolStaticCenter.commonLog.info("BeeCP({})has shutdown", (Object)this.poolName);
                break;
            }
            if (this.poolState.get() == 3) break;
            LockSupport.parkNanos(this.DelayTimeForNextClearNanos);
        }
    }

    @Override
    public ConnectionPoolMonitorVo getMonitorVo() {
        int totSize = this.getConnTotalSize();
        int idleSize = this.getConnIdleSize();
        this.monitorVo.setPoolName(this.poolName);
        this.monitorVo.setPoolMode(this.poolMode);
        this.monitorVo.setPoolState(this.poolState.get());
        this.monitorVo.setMaxActive(this.PoolMaxSize);
        this.monitorVo.setIdleSize(idleSize);
        this.monitorVo.setUsingSize(totSize - idleSize);
        this.monitorVo.setSemaphoreWaiterSize(this.getSemaphoreWaitingSize());
        this.monitorVo.setTransferWaiterSize(this.getTransferWaitingSize());
        return this.monitorVo;
    }

    @Override
    public int getConnTotalSize() {
        return this.conArray.length;
    }

    @Override
    public int getConnIdleSize() {
        int idleConnections = 0;
        for (PooledConnection pCon : this.conArray) {
            if (pCon.state != 1) continue;
            ++idleConnections;
        }
        return idleConnections;
    }

    @Override
    public int getConnUsingSize() {
        int active = this.conArray.length - this.getConnIdleSize();
        return active > 0 ? active : 0;
    }

    @Override
    public int getSemaphoreAcquiredSize() {
        return this.poolConfig.getBorrowSemaphoreSize() - this.semaphore.availablePermits();
    }

    @Override
    public int getSemaphoreWaitingSize() {
        return this.semaphore.getQueueLength();
    }

    @Override
    public int getTransferWaitingSize() {
        int size = 0;
        for (Borrower borrower : this.waitQueue) {
            Object state = borrower.state;
            if (state != PoolStaticCenter.BOWER_NORMAL && state != PoolStaticCenter.BOWER_WAITING) continue;
            ++size;
        }
        return size;
    }

    private void registerJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registerJmxBean(mBeanServer, String.format("cn.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName), this);
            this.registerJmxBean(mBeanServer, String.format("cn.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName), this.poolConfig);
        }
    }

    private void registerJmxBean(MBeanServer mBeanServer, String regName, Object bean) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (!mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.registerMBean(bean, jmxRegName);
            }
        }
        catch (Exception e) {
            PoolStaticCenter.commonLog.warn("BeeCP({})failed to register jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    private void unregisterJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.unregisterJmxBean(mBeanServer, String.format("cn.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName));
            this.unregisterJmxBean(mBeanServer, String.format("cn.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName));
        }
    }

    private void unregisterJmxBean(MBeanServer mBeanServer, String regName) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.unregisterMBean(jmxRegName);
            }
        }
        catch (Exception e) {
            PoolStaticCenter.commonLog.warn("BeeCP({})failed to unregister jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    private class ConnectionPoolHook
    extends Thread {
        private ConnectionPoolHook() {
        }

        @Override
        public void run() {
            try {
                PoolStaticCenter.commonLog.info("ConnectionPoolHook Running");
                FastConnectionPool.this.close();
            }
            catch (Throwable e) {
                PoolStaticCenter.commonLog.error("Error at closing connection pool,cause:", e);
            }
        }
    }

    final class DynAddPooledConnTask
    implements Runnable {
        DynAddPooledConnTask() {
        }

        @Override
        public void run() {
            while (FastConnectionPool.this.needAddConSize.get() > 0) {
                FastConnectionPool.this.needAddConSize.decrementAndGet();
                if (FastConnectionPool.this.waitQueue.isEmpty()) continue;
                try {
                    PooledConnection pCon = FastConnectionPool.this.createPooledConn(2);
                    if (pCon == null) continue;
                    FastConnectionPool.this.recycle(pCon);
                }
                catch (Throwable e) {
                    FastConnectionPool.this.transferException(e instanceof SQLException ? (SQLException)e : new SQLException(e));
                }
            }
        }
    }

    private static final class PoolThreadThreadFactory
    implements ThreadFactory {
        private String thName;

        public PoolThreadThreadFactory(String thName) {
            this.thName = thName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, this.thName);
            th.setDaemon(true);
            return th;
        }
    }

    private static final class ConnValidTester
    extends ConnectionTester {
        public ConnValidTester(String poolName, int ConTestTimeout) {
            super(poolName, ConTestTimeout);
        }

        @Override
        public final boolean isAlive(PooledConnection pCon) {
            try {
                if (pCon.rawCon.isValid(this.ConTestTimeout)) {
                    pCon.lastAccessTime = System.currentTimeMillis();
                    return true;
                }
            }
            catch (Throwable e) {
                PoolStaticCenter.commonLog.error("BeeCP({})failed to test connection", (Object)this.poolName, (Object)e);
            }
            return false;
        }
    }

    private static final class SqlQueryTester
    extends ConnectionTester {
        private final String testSql;
        private final boolean autoCommit;
        private boolean supportQueryTimeout = true;

        public SqlQueryTester(String poolName, int ConTestTimeout, boolean autoCommit, String testSql) {
            super(poolName, ConTestTimeout);
            this.autoCommit = autoCommit;
            this.testSql = testSql;
        }

        public void setSupportQueryTimeout(boolean supportQueryTimeout) {
            this.supportQueryTimeout = supportQueryTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean isAlive(PooledConnection pCon) {
            Statement st = null;
            boolean changed = false;
            Connection con = pCon.rawCon;
            try {
                if (this.autoCommit) {
                    con.setAutoCommit(false);
                    changed = true;
                }
                st = con.createStatement();
                if (this.supportQueryTimeout) {
                    try {
                        st.setQueryTimeout(this.ConTestTimeout);
                    }
                    catch (Throwable e) {
                        PoolStaticCenter.commonLog.error("BeeCP({})failed to setQueryTimeout", (Object)this.poolName, (Object)e);
                    }
                }
                st.execute(this.testSql);
                pCon.lastAccessTime = System.currentTimeMillis();
                boolean e = true;
                return e;
            }
            catch (Throwable e) {
                PoolStaticCenter.commonLog.error("BeeCP({})failed to test connection", (Object)this.poolName, (Object)e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.rollback();
                    if (st != null) {
                        PoolStaticCenter.oclose(st);
                    }
                    if (changed) {
                        con.setAutoCommit(this.autoCommit);
                    }
                }
                catch (Throwable e) {
                    PoolStaticCenter.commonLog.error("BeeCP({})failed to rest connection after sql test", (Object)this.poolName, (Object)e);
                    return false;
                }
            }
        }
    }

    private static abstract class ConnectionTester {
        protected final String poolName;
        protected final int ConTestTimeout;

        public ConnectionTester(String poolName, int ConTestTimeout) {
            this.poolName = poolName;
            this.ConTestTimeout = ConTestTimeout;
        }

        abstract boolean isAlive(PooledConnection var1);
    }

    private static final class FairTransferPolicy
    implements TransferPolicy {
        private FairTransferPolicy() {
        }

        @Override
        public final int getCheckStateCode() {
            return 2;
        }

        @Override
        public final void beforeTransfer(PooledConnection p) {
        }

        @Override
        public final boolean tryCatch(PooledConnection p) {
            return p.state == 2;
        }

        @Override
        public final void onFailedTransfer(PooledConnection p) {
            p.state = 1;
        }
    }

    private static final class CompeteTransferPolicy
    implements TransferPolicy {
        private CompeteTransferPolicy() {
        }

        @Override
        public final int getCheckStateCode() {
            return 1;
        }

        @Override
        public final void beforeTransfer(PooledConnection p) {
            p.state = 1;
        }

        @Override
        public final boolean tryCatch(PooledConnection p) {
            return ConStUpd.compareAndSet(p, 1, 2);
        }

        @Override
        public final void onFailedTransfer(PooledConnection p) {
        }
    }

    private static interface TransferPolicy {
        public int getCheckStateCode();

        public void beforeTransfer(PooledConnection var1);

        public boolean tryCatch(PooledConnection var1);

        public void onFailedTransfer(PooledConnection var1);
    }
}

