/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.BeeDataSourceConfigJmxBean;
import cn.beecp.ConnectionFactory;
import cn.beecp.TransactionIsolationLevel;
import cn.beecp.pool.DataSourceConnectionFactory;
import cn.beecp.pool.DriverConnectionFactory;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.xa.XaConnectionFactory;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class BeeDataSourceConfig
implements BeeDataSourceConfigJmxBean {
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private String defaultCatalog;
    private String defaultSchema;
    private boolean defaultReadOnly;
    private boolean defaultAutoCommit = true;
    private int defaultTransactionIsolationCode = 2;
    private String defaultTransactionIsolation = "READ_COMMITTED";
    private String poolName;
    private boolean fairMode;
    private int initialSize;
    private int maxActive = 10;
    private int borrowSemaphoreSize = Math.min(this.maxActive / 2, Runtime.getRuntime().availableProcessors());
    private long maxWait = TimeUnit.SECONDS.toMillis(8L);
    private long idleTimeout = TimeUnit.MINUTES.toMillis(3L);
    private long holdTimeout = TimeUnit.MINUTES.toMillis(5L);
    private String connectionTestSql = "SELECT 1";
    private int connectionTestTimeout = 3;
    private long connectionTestInterval = 500L;
    private long idleCheckTimeInterval = TimeUnit.MINUTES.toMillis(3L);
    private boolean forceCloseUsingOnClear;
    private long delayTimeForNextClear = 3000L;
    private ConnectionFactory connectionFactory;
    private String connectionFactoryClassName;
    private XaConnectionFactory xaConnectionFactory;
    private String xaConnectionFactoryClassName;
    private Properties connectProperties = new Properties();
    private String poolImplementClassName;
    private boolean enableJmx;

    public BeeDataSourceConfig() {
    }

    public BeeDataSourceConfig(String driver, String url, String user, String password) {
        this.jdbcUrl = this.trimString(url);
        this.username = this.trimString(user);
        this.password = this.trimString(password);
        this.driverClassName = this.trimString(driver);
    }

    public BeeDataSourceConfig(File propertiesFile) {
        this.loadFromPropertiesFile(propertiesFile);
    }

    public BeeDataSourceConfig(String propertiesFileName) {
        this.loadFromPropertiesFile(propertiesFileName);
    }

    public BeeDataSourceConfig(Properties configProperties) {
        this.loadFromProperties(configProperties);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = this.trimString(username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = this.trimString(password);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = this.trimString(jdbcUrl);
    }

    @Override
    public String getUrl() {
        return this.jdbcUrl;
    }

    public void setUrl(String jdbcUrl) {
        this.jdbcUrl = this.trimString(jdbcUrl);
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = this.trimString(driverClassName);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = this.trimString(defaultCatalog);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = this.trimString(defaultSchema);
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @Override
    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @Override
    public int getDefaultTransactionIsolationCode() {
        return this.defaultTransactionIsolationCode;
    }

    public void setDefaultTransactionIsolationCode(int defaultTransactionIsolationCode) {
        this.defaultTransactionIsolationCode = defaultTransactionIsolationCode;
    }

    @Override
    public String getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(String defaultTransactionIsolation) {
        this.defaultTransactionIsolation = this.trimString(defaultTransactionIsolation);
    }

    @Override
    public String getConnectionTestSql() {
        return this.connectionTestSql;
    }

    public void setConnectionTestSql(String connectionTestSql) {
        if (!PoolStaticCenter.isBlank(connectionTestSql)) {
            this.connectionTestSql = this.trimString(connectionTestSql);
        }
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = this.trimString(poolName);
    }

    @Override
    public boolean isFairMode() {
        return this.fairMode;
    }

    public void setFairMode(boolean fairMode) {
        this.fairMode = fairMode;
    }

    @Override
    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (initialSize >= 0) {
            this.initialSize = initialSize;
        }
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        if (maxActive > 0) {
            this.maxActive = maxActive;
            this.borrowSemaphoreSize = maxActive > 1 ? Math.min(maxActive / 2, Runtime.getRuntime().availableProcessors()) : 1;
        }
    }

    @Override
    public int getBorrowSemaphoreSize() {
        return this.borrowSemaphoreSize;
    }

    public void setBorrowSemaphoreSize(int borrowSemaphoreSize) {
        if (borrowSemaphoreSize > 0) {
            this.borrowSemaphoreSize = borrowSemaphoreSize;
        }
    }

    @Override
    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        if (maxWait > 0L) {
            this.maxWait = maxWait;
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout > 0L) {
            this.idleTimeout = idleTimeout;
        }
    }

    @Override
    public long getHoldTimeout() {
        return this.holdTimeout;
    }

    public void setHoldTimeout(long holdTimeout) {
        if (holdTimeout > 0L) {
            this.holdTimeout = holdTimeout;
        }
    }

    @Override
    public int getConnectionTestTimeout() {
        return this.connectionTestTimeout;
    }

    public void setConnectionTestTimeout(int connectionTestTimeout) {
        if (connectionTestTimeout >= 0) {
            this.connectionTestTimeout = connectionTestTimeout;
        }
    }

    @Override
    public long getConnectionTestInterval() {
        return this.connectionTestInterval;
    }

    public void setConnectionTestInterval(long connectionTestInterval) {
        if (connectionTestInterval >= 0L) {
            this.connectionTestInterval = connectionTestInterval;
        }
    }

    @Override
    public long getIdleCheckTimeInterval() {
        return this.idleCheckTimeInterval;
    }

    public void setIdleCheckTimeInterval(long idleCheckTimeInterval) {
        if (idleCheckTimeInterval > 0L) {
            this.idleCheckTimeInterval = idleCheckTimeInterval;
        }
    }

    @Override
    public boolean isForceCloseUsingOnClear() {
        return this.forceCloseUsingOnClear;
    }

    public void setForceCloseUsingOnClear(boolean forceCloseUsingOnClear) {
        this.forceCloseUsingOnClear = forceCloseUsingOnClear;
    }

    @Override
    public long getDelayTimeForNextClear() {
        return this.delayTimeForNextClear;
    }

    public void setDelayTimeForNextClear(long delayTimeForNextClear) {
        if (delayTimeForNextClear > 0L) {
            this.delayTimeForNextClear = delayTimeForNextClear;
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public void setConnectionFactoryClassName(String connectionFactoryClassName) {
        this.connectionFactoryClassName = this.trimString(connectionFactoryClassName);
    }

    public XaConnectionFactory getXaConnectionFactory() {
        return this.xaConnectionFactory;
    }

    public void setXaConnectionFactory(XaConnectionFactory xaConnectionFactory) {
        this.xaConnectionFactory = xaConnectionFactory;
    }

    public String getXaConnectionFactoryClassName() {
        return this.xaConnectionFactoryClassName;
    }

    public void setXaConnectionFactoryClassName(String xaConnectionFactoryClassName) {
        this.xaConnectionFactoryClassName = this.trimString(xaConnectionFactoryClassName);
    }

    public void removeConnectProperty(String key) {
        this.connectProperties.remove(key);
    }

    public void addConnectProperty(String key, Object value) {
        this.connectProperties.put(key, value);
    }

    @Override
    public String getPoolImplementClassName() {
        return this.poolImplementClassName;
    }

    public void setPoolImplementClassName(String poolImplementClassName) {
        this.poolImplementClassName = this.trimString(poolImplementClassName);
    }

    @Override
    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    void copyTo(BeeDataSourceConfig config) throws SQLException {
        Field[] fields;
        for (Field field : fields = BeeDataSourceConfig.class.getDeclaredFields()) {
            if ("connectProperties".equals(field.getName())) continue;
            try {
                Object fieldValue = field.get(this);
                PoolStaticCenter.commonLog.debug("BeeDataSourceConfig.{}={}", (Object)field.getName(), fieldValue);
                field.set(config, fieldValue);
            }
            catch (Exception e) {
                throw new BeeDataSourceConfigException("Failed to copy field[" + field.getName() + "]", e);
            }
        }
        for (Map.Entry<Object, Object> entry : this.connectProperties.entrySet()) {
            PoolStaticCenter.commonLog.debug("BeeDataSourceConfig.connectProperties.{}={}", entry.getKey(), entry.getValue());
            config.addConnectProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public BeeDataSourceConfig check() throws SQLException {
        if (this.maxActive <= 0) {
            throw new BeeDataSourceConfigException("maxActive must be greater than zero");
        }
        if (this.initialSize < 0) {
            throw new BeeDataSourceConfigException("initialSize must be greater than zero");
        }
        if (this.initialSize > this.maxActive) {
            throw new BeeDataSourceConfigException("initialSize must not be greater than maxActive");
        }
        if (this.borrowSemaphoreSize <= 0) {
            throw new BeeDataSourceConfigException("borrowSemaphoreSize must be greater than zero");
        }
        if (this.idleTimeout <= 0L) {
            throw new BeeDataSourceConfigException("idleTimeout must be greater than zero");
        }
        if (this.holdTimeout <= 0L) {
            throw new BeeDataSourceConfigException("holdTimeout must be greater than zero");
        }
        if (this.maxWait <= 0L) {
            throw new BeeDataSourceConfigException("maxWait must be greater than zero");
        }
        if (PoolStaticCenter.isBlank(this.connectionTestSql)) {
            throw new BeeDataSourceConfigException("connectionTestSql cant be null or empty");
        }
        if (!this.connectionTestSql.toLowerCase(Locale.US).startsWith("select ")) {
            System.out.println("connectionTestSql:" + this.connectionTestSql);
            throw new BeeDataSourceConfigException("connectionTestSql must be start with 'select '");
        }
        int transactionIsolationCode = this.getTransactionIsolationCode();
        ConnectionFactory connectionFactory = this.tryCreateConnectionFactory();
        BeeDataSourceConfig configCopy = new BeeDataSourceConfig();
        this.copyTo(configCopy);
        configCopy.setConnectionFactory(connectionFactory);
        configCopy.setDefaultTransactionIsolationCode(transactionIsolationCode);
        return configCopy;
    }

    public void loadFromPropertiesFile(String filename) {
        if (PoolStaticCenter.isBlank(filename)) {
            throw new IllegalArgumentException("Properties file can't be null");
        }
        this.loadFromPropertiesFile(new File(filename));
    }

    public void loadFromPropertiesFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Properties file can't be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found:" + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Target object is not a valid file");
        }
        if (!file.getAbsolutePath().toLowerCase(Locale.US).endsWith(".properties")) {
            throw new IllegalArgumentException("Target file is not a properties file");
        }
        InputStream stream = null;
        try {
            stream = Files.newInputStream(Paths.get(file.toURI()), new OpenOption[0]);
            Properties configProperties = new Properties();
            configProperties.load(stream);
            this.loadFromProperties(configProperties);
        }
        catch (BeeDataSourceConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to load properties file:", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void loadFromProperties(Properties configProperties) {
        if (configProperties == null || configProperties.isEmpty()) {
            throw new IllegalArgumentException("Properties can't be null or empty");
        }
        Map<String, Method> setMethodMap = PoolStaticCenter.getSetMethodMap(BeeDataSourceConfig.class);
        HashMap<String, Object> setValueMap = new HashMap<String, Object>(setMethodMap.size());
        for (String propertyName : setMethodMap.keySet()) {
            String configVal = this.getConfigValue(configProperties, propertyName);
            if (PoolStaticCenter.isBlank(configVal)) continue;
            setValueMap.put(propertyName, configVal);
        }
        PoolStaticCenter.setPropertiesValue(this, setMethodMap, setValueMap);
        String connectPropVal = this.getConfigValue(configProperties, "connectProperties");
        if (!PoolStaticCenter.isBlank(connectPropVal)) {
            String[] attributeArray;
            for (String attribute : attributeArray = connectPropVal.split("&")) {
                String[] pairs = attribute.split("=");
                if (pairs.length != 2) continue;
                this.addConnectProperty(pairs[0].trim(), pairs[1].trim());
                PoolStaticCenter.commonLog.info("beecp.connectProperties.{}={}", (Object)pairs[0].trim(), (Object)pairs[1].trim());
            }
        }
    }

    private final String getConfigValue(Properties configProperties, String propertyName) {
        String value = this.readConfig(configProperties, propertyName);
        if (PoolStaticCenter.isBlank(value)) {
            value = this.readConfig(configProperties, PoolStaticCenter.propertyNameToFieldId(propertyName, "-"));
        }
        if (PoolStaticCenter.isBlank(value)) {
            value = this.readConfig(configProperties, PoolStaticCenter.propertyNameToFieldId(propertyName, "_"));
        }
        return value;
    }

    private final String readConfig(Properties configProperties, String propertyName) {
        String value = configProperties.getProperty(propertyName);
        if (!PoolStaticCenter.isBlank(value)) {
            PoolStaticCenter.commonLog.info("beecp.{}={}", (Object)propertyName, (Object)value);
            return value.trim();
        }
        return null;
    }

    private String trimString(String value) {
        return value == null ? null : value.trim();
    }

    private final int getTransactionIsolationCode() throws BeeDataSourceConfigException {
        if (!PoolStaticCenter.isBlank(this.defaultTransactionIsolation)) {
            int transactionIsolationCode = TransactionIsolationLevel.getTransactionIsolationCode(this.defaultTransactionIsolation);
            if (transactionIsolationCode == -999) {
                throw new BeeDataSourceConfigException("defaultTransactionIsolation error,valid value is one of[NONE,READ_COMMITTED,READ_UNCOMMITTED,REPEATABLE_READ,SERIALIZABLE]");
            }
            return transactionIsolationCode;
        }
        if (!TransactionIsolationLevel.isValidTransactionIsolationCode(this.defaultTransactionIsolationCode)) {
            throw new BeeDataSourceConfigException("defaultTransactionIsolationCode error,valid value is one of[" + TransactionIsolationLevel.TRANS_LEVEL_CODE_LIST + "]");
        }
        return this.defaultTransactionIsolationCode;
    }

    private final Driver loadJdbcDriver(String driverClassName) throws BeeDataSourceConfigException {
        try {
            Class<?> driverClass = Class.forName(driverClassName, true, BeeDataSourceConfig.class.getClassLoader());
            return (Driver)driverClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BeeDataSourceConfigException("Not found driver class:" + driverClassName);
        }
        catch (InstantiationException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate driver class:" + driverClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate driver class:" + driverClassName, e);
        }
    }

    private final ConnectionFactory tryCreateConnectionFactory() throws BeeDataSourceConfigException, SQLException {
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        if (PoolStaticCenter.isBlank(this.connectionFactoryClassName)) {
            if (PoolStaticCenter.isBlank(this.jdbcUrl)) {
                throw new BeeDataSourceConfigException("jdbcUrl can't be null");
            }
            Driver connectDriver = null;
            if (!PoolStaticCenter.isBlank(this.driverClassName)) {
                connectDriver = this.loadJdbcDriver(this.driverClassName);
            } else if (!PoolStaticCenter.isBlank(this.jdbcUrl)) {
                connectDriver = DriverManager.getDriver(this.jdbcUrl);
            }
            if (connectDriver == null) {
                throw new BeeDataSourceConfigException("Failed to load jdbc Driver:" + this.driverClassName);
            }
            if (!connectDriver.acceptsURL(this.jdbcUrl)) {
                throw new BeeDataSourceConfigException("jdbcUrl(" + this.jdbcUrl + ")can not match driver:" + connectDriver.getClass().getName());
            }
            Properties connectProperties = new Properties();
            connectProperties.putAll((Map<?, ?>)this.connectProperties);
            if (!PoolStaticCenter.isBlank(this.username)) {
                connectProperties.put("user", this.username);
            }
            if (!PoolStaticCenter.isBlank(this.password)) {
                connectProperties.put("password", this.password);
            }
            return new DriverConnectionFactory(this.jdbcUrl, connectDriver, connectProperties);
        }
        try {
            Class<?> conFactClass = Class.forName(this.connectionFactoryClassName, true, BeeDataSourceConfig.class.getClassLoader());
            if (ConnectionFactory.class.isAssignableFrom(conFactClass)) {
                return (ConnectionFactory)conFactClass.newInstance();
            }
            if (DataSource.class.isAssignableFrom(conFactClass)) {
                DataSource dataSource = (DataSource)conFactClass.newInstance();
                Properties connectProperties = this.connectProperties;
                HashMap<String, Object> setValueMap = new HashMap<String, Object>(connectProperties.size());
                for (Map.Entry<Object, Object> entry : connectProperties.entrySet()) {
                    if (!(entry.getKey() instanceof String)) continue;
                    setValueMap.put((String)entry.getKey(), entry.getValue());
                }
                try {
                    PoolStaticCenter.setPropertiesValue(dataSource, setValueMap);
                }
                catch (Exception e) {
                    throw new BeeDataSourceConfigException("Failed to set config value to connection dataSource", e);
                }
                return new DataSourceConnectionFactory(dataSource, this.username, this.password);
            }
            throw new BeeDataSourceConfigException("Error connection factory class,must implement '" + ConnectionFactory.class.getName() + "' interface");
        }
        catch (ClassNotFoundException e) {
            throw new BeeDataSourceConfigException("Not found connection factory class:" + this.connectionFactoryClassName);
        }
        catch (InstantiationException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate connection factory class:" + this.connectionFactoryClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate connection factory class:" + this.connectionFactoryClassName, e);
        }
    }
}

