/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpAgentService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpAgent;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpAgentServiceImpl
implements WxCpAgentService {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private final WxCpService mainService;

    @Override
    public WxCpAgent get(Integer agentId) throws WxErrorException {
        if (agentId == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11agentid\u53c2\u6570");
        }
        String url = String.format(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/agent/get?agentid=%d"), agentId);
        return WxCpAgent.fromJson(this.mainService.get(url, null));
    }

    @Override
    public void set(WxCpAgent agentInfo) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/agent/set");
        String responseContent = this.mainService.post(url, agentInfo.toJson());
        JsonObject jsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.CP));
        }
    }

    @Override
    public List<WxCpAgent> list() throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/agent/list");
        String responseContent = this.mainService.get(url, null);
        JsonObject jsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.CP));
        }
        return (List)WxCpGsonBuilder.create().fromJson(jsonObject.get("agentlist").toString(), new TypeToken<List<WxCpAgent>>(){}.getType());
    }

    public WxCpAgentServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

