/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpExternalContactService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpUserExternalContactInfo;
import me.chanjar.weixin.cp.bean.WxCpUserExternalContactList;
import me.chanjar.weixin.cp.bean.WxCpUserWithExternalPermission;

public class WxCpExternalContactServiceImpl
implements WxCpExternalContactService {
    private WxCpService mainService;

    public WxCpExternalContactServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public WxCpUserExternalContactInfo getExternalContact(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/crm/get_external_contact?external_userid=" + userId);
        String responseContent = this.mainService.get(url, null);
        return WxCpUserExternalContactInfo.fromJson(responseContent);
    }

    @Override
    public WxCpUserExternalContactInfo getContactDetail(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get?external_userid=" + userId);
        String responseContent = this.mainService.get(url, null);
        return WxCpUserExternalContactInfo.fromJson(responseContent);
    }

    @Override
    public List<String> listExternalContacts(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/list?userid=" + userId);
        String responseContent = this.mainService.get(url, null);
        return WxCpUserExternalContactList.fromJson(responseContent).getExternalUserId();
    }

    @Override
    public List<String> listFollowUser() throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_follow_user_list");
        String responseContent = this.mainService.get(url, null);
        return WxCpUserWithExternalPermission.fromJson(responseContent).getFollowUser();
    }
}

