/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.util;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.JavaTypeResolver;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.VerboseProgressCallback;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.db.DatabaseIntrospector;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class TableKits {
    private final DbType dbType;
    private final Connection connection;
    private String schema;
    private Properties properties;
    private final List<String> warnings = new ArrayList<String>();
    private static final List<DbType> nullCatalogMeansCurrent = Arrays.asList(DbType.MYSQL, DbType.MARIADB);

    TableKits(DbType dbType, Connection connection) {
        this.dbType = dbType;
        this.connection = connection;
    }

    public List<IntrospectedTable> findTables(Collection<String> tables) {
        ArrayList<IntrospectedTable> introspectedTables = new ArrayList<IntrospectedTable>();
        try {
            VerboseProgressCallback callback = new VerboseProgressCallback();
            Context ctx = this.getContext(tables);
            JavaTypeResolver javaTypeResolver = ObjectFactory.createJavaTypeResolver((Context)ctx, this.warnings);
            if (this.properties != null) {
                javaTypeResolver.addConfigurationProperties(this.properties);
            }
            DatabaseIntrospector databaseIntrospector = new DatabaseIntrospector(ctx, this.connection.getMetaData(), javaTypeResolver, this.warnings);
            List tcs = ctx.getTableConfigurations();
            for (TableConfiguration tc : tcs) {
                List<IntrospectedTable> ts = this.introspectTables(tc, (ProgressCallback)callback, databaseIntrospector);
                if (ts == null) continue;
                introspectedTables.addAll(ts);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("find tables error:" + e.getMessage(), e);
        }
        return introspectedTables;
    }

    private List<IntrospectedTable> introspectTables(TableConfiguration tc, ProgressCallback callback, DatabaseIntrospector databaseIntrospector) throws Exception {
        String tableName = StringUtility.composeFullyQualifiedTableName((String)tc.getCatalog(), (String)tc.getSchema(), (String)tc.getTableName(), (char)'.');
        callback.startTask(Messages.getString((String)"Progress.1", (String)tableName));
        List tables = databaseIntrospector.introspectTables(tc);
        callback.checkCancel();
        return tables;
    }

    private Context getContext(Collection<String> tables) {
        Context ctx = new Context(null);
        ctx.setTargetRuntime("MyBatis3");
        ctx.setId("MySqlContext");
        for (String tableName : tables) {
            ctx.addTableConfiguration(this.tableConfiguration(ctx, tableName));
        }
        return ctx;
    }

    private TableConfiguration tableConfiguration(Context ctx, String tableName) {
        int index;
        TableConfiguration conf = new TableConfiguration(ctx);
        conf.setDelimitIdentifiers(true);
        int n = index = this.schema == null ? -1 : this.schema.indexOf(46);
        if (index >= 0) {
            conf.setCatalog(this.schema.substring(0, index));
            conf.setSchema(this.schema.substring(index + 1));
        } else {
            conf.setSchema(this.schema);
            if (nullCatalogMeansCurrent.contains(this.dbType)) {
                conf.setCatalog(this.schema);
            }
        }
        conf.setTableName(tableName);
        return conf;
    }

    public TableKits setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public TableKits setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }
}

