/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.javafile;

import cn.org.atool.generator.database.IGlobalConfig;
import cn.org.atool.generator.database.ITableConfig;
import cn.org.atool.generator.database.ITableConfigSet;
import cn.org.atool.generator.database.config.impl.GlobalConfig;
import cn.org.atool.generator.database.config.impl.TableConfigSet;
import cn.org.atool.generator.database.model.TableSetter;
import cn.org.atool.generator.javafile.summary.ATMFile;
import cn.org.atool.generator.javafile.template.DaoImplementFile;
import cn.org.atool.generator.javafile.template.DaoInterfaceFile;
import cn.org.atool.generator.javafile.template.DataMapFile;
import cn.org.atool.generator.javafile.template.EntityFile;
import cn.org.atool.generator.javafile.template.TableMixFile;
import cn.org.atool.generator.util.GeneratorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class TemplateGenerator
implements IGlobalConfig,
ITableConfig {
    public static boolean withTest = false;
    protected static boolean withEntity = false;
    protected TableConfigSet tableConfigs;
    protected GlobalConfig globalConfig = new GlobalConfig();
    private static final List<TableSetter> tables = new ArrayList<TableSetter>();
    private static String basePackage = null;
    private static String globalTestDir = null;

    public static IGlobalConfig build(boolean withEntity, boolean withTest) {
        if (!withEntity && !withTest) {
            throw new RuntimeException("At last one of Entity or Test generation must be true");
        }
        TemplateGenerator generator = new TemplateGenerator();
        TemplateGenerator.withTest = withTest;
        TemplateGenerator.withEntity = withEntity;
        return generator;
    }

    @Override
    public ITableConfig globalConfig(Consumer<GlobalConfig> consumer) {
        consumer.accept(this.globalConfig);
        return this;
    }

    @Override
    public ITableConfig tables(Consumer<ITableConfigSet> consumer) {
        TableConfigSet tableConfig = new TableConfigSet(this.globalConfig);
        consumer.accept(tableConfig);
        this.tables(tableConfig);
        return this;
    }

    @Override
    public ITableConfig relations(Consumer<TableConfigSet> consumer) {
        consumer.accept(this.tableConfigs);
        return this;
    }

    public ITableConfig tables(ITableConfigSet ... tableConfigs) {
        if (this.tableConfigs == null) {
            this.tableConfigs = new TableConfigSet(this.globalConfig);
        }
        for (ITableConfigSet tableConfig : tableConfigs) {
            this.tableConfigs.add((TableConfigSet)tableConfig);
        }
        return this;
    }

    @Override
    public void execute() {
        if (this.globalConfig == null) {
            throw new RuntimeException("The global config not set.");
        }
        GeneratorHelper.info("=== Database metadata initializing...");
        this.tableConfigs.initTables();
        this.tableConfigs.initRelations();
        GeneratorHelper.info("=== Preparing for file generation...");
        this.tableConfigs.getTables().values().forEach(table -> {
            this.generateFiles((TableSetter)table);
            tables.add((TableSetter)table);
        });
        GeneratorHelper.info("=== File generation finish !!!");
        TemplateGenerator.setBasePackage(this.globalConfig.getBasePackage());
        TemplateGenerator.setGlobalTestDir(this.globalConfig.getTestOutputDir());
    }

    private void generateFiles(TableSetter table) {
        GlobalConfig gc = table.gc();
        GeneratorHelper.info("====== Handling table: " + table.getTableName());
        if (withTest) {
            GeneratorHelper.info("====== Writing test file to " + table.gc().getTestOutputDir());
            new DataMapFile(table).javaFile(gc.getTestOutputDir(), true);
            new TableMixFile(table).javaFile(gc.getTestOutputDir(), true);
        }
        if (withEntity) {
            GeneratorHelper.info("====== Writing entity file to " + table.gc().getOutputDir());
            new EntityFile(table).javaFile(gc.getOutputDir(), true);
        }
        if (withEntity && table.isUseDao()) {
            GeneratorHelper.info("====== Writing dao&impl file to " + table.gc().getDaoOutputDir());
            new DaoInterfaceFile(table).javaFile(gc.getDaoOutputDir(), false);
            new DaoImplementFile(table).javaFile(gc.getDaoOutputDir(), false);
        }
    }

    public static void setBasePackage(String _package) {
        basePackage = GeneratorHelper.sameStartPackage(basePackage, _package);
    }

    public static void setGlobalTestDir(String dir) {
        if (!GeneratorHelper.isBlank(dir)) {
            globalTestDir = dir;
        }
    }

    public static void generateSummary() {
        new ATMFile(basePackage, tables).javaFile(globalTestDir, true);
    }

    public TableConfigSet getTableConfigs() {
        return this.tableConfigs;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }
}

