/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.javafile;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;

public abstract class AbstractFile {
    protected String packageName;
    protected String klassName;
    protected String comment;

    protected ClassName className() {
        return ClassName.get((String)this.packageName, (String)this.klassName, (String[])new String[0]);
    }

    public final void javaFile(String srcDir, boolean forceWrite) {
        this.javaFile(new File(srcDir), forceWrite);
    }

    public final void javaFile(File srcDir, boolean forceWrite) {
        if (!forceWrite && new File(srcDir + this.filePath()).exists()) {
            System.out.println(".......... File " + this.klassName + ".java already exist, skip according to configuration");
            return;
        }
        TypeSpec.Builder builder = this.getBuilder();
        this.build(builder);
        try {
            JavaFile.Builder javaBuilder = JavaFile.builder((String)this.packageName, (TypeSpec)builder.build());
            this.staticImport(javaBuilder);
            javaBuilder.skipJavaLangImports(true);
            javaBuilder.build().writeTo(srcDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate java file: " + e.getMessage(), e);
        }
    }

    private String filePath() {
        return "/" + this.packageName.replace('.', '/') + "/" + this.klassName + ".java";
    }

    protected void staticImport(JavaFile.Builder builder) {
    }

    protected abstract void build(TypeSpec.Builder var1);

    protected TypeName parameterizedType(ClassName raw, TypeName ... paras) {
        return ParameterizedTypeName.get((ClassName)raw, (TypeName[])paras);
    }

    protected TypeName parameterizedType(Class raw, Class ... paras) {
        return ParameterizedTypeName.get((Class)raw, (Type[])paras);
    }

    protected abstract boolean isInterface();

    private TypeSpec.Builder getBuilder() {
        if (this.isInterface()) {
            return TypeSpec.interfaceBuilder((String)this.klassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        return TypeSpec.classBuilder((String)this.klassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    protected CodeBlock codeBlock(String ... lines) {
        return CodeBlock.join((Iterable)Stream.of(lines).map(x$0 -> CodeBlock.of((String)x$0, (Object[])new Object[0])).collect(Collectors.toList()), (String)"\n");
    }

    public void writeTo(Filer filer) {
        TypeSpec.Builder builder = this.getBuilder();
        CodeBlock comment = this.codeBlock("", this.klassName + (this.comment == null ? "" : ": " + this.comment), "", "@author powered by " + this.generatorName());
        builder.addJavadoc("$L", new Object[]{comment});
        this.build(builder);
        try {
            JavaFile.Builder javaBuilder = JavaFile.builder((String)this.packageName, (TypeSpec)builder.build());
            this.staticImport(javaBuilder);
            javaBuilder.build().writeTo(filer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected AnnotationSpec suppressWarnings(String ... values) {
        String formats = Stream.of(values).map(s -> "$S").collect(Collectors.joining(", ", "{", "}"));
        return AnnotationSpec.builder(SuppressWarnings.class).addMember("value", formats, (Object[])values).build();
    }

    protected String generatorName() {
        return "Test4J";
    }
}

