/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.config.impl;

import cn.org.atool.generator.database.model.FieldType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class ColumnConfig {
    private String column;
    private String field;
    private String insert;
    private String update;
    private boolean isLarge = false;
    private TypeName javaType;
    private JdbcType jdbcType;
    private Class<? extends TypeHandler> typeHandler;
    private FieldType category;
    public static final Map<String, ColumnConfig> configs = new HashMap<String, ColumnConfig>();

    public void setJavaType(Class klass) {
        this.javaType = ClassName.get((Class)klass);
    }

    public void setJavaType(Class klass, Class ... argTypes) {
        this.javaType = ParameterizedTypeName.get((Class)klass, (Type[])argTypes);
    }

    public static ColumnConfig set(String table, String column, String field) {
        return ColumnConfig.set(table, column).setField(field);
    }

    public static ColumnConfig set(String table, String column) {
        ColumnConfig config = new ColumnConfig().setColumn(column);
        configs.put(table + "#" + column, config);
        return config;
    }

    public static ColumnConfig get(String tableName, String columnName) {
        if (configs.containsKey(tableName + "#" + columnName)) {
            return configs.get(tableName + "#" + columnName);
        }
        return configs.get("*#" + columnName);
    }

    public String getColumn() {
        return this.column;
    }

    public String getField() {
        return this.field;
    }

    public String getInsert() {
        return this.insert;
    }

    public String getUpdate() {
        return this.update;
    }

    public boolean isLarge() {
        return this.isLarge;
    }

    public TypeName getJavaType() {
        return this.javaType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public Class<? extends TypeHandler> getTypeHandler() {
        return this.typeHandler;
    }

    public FieldType getCategory() {
        return this.category;
    }

    public ColumnConfig setColumn(String column) {
        this.column = column;
        return this;
    }

    public ColumnConfig setField(String field) {
        this.field = field;
        return this;
    }

    public ColumnConfig setInsert(String insert) {
        this.insert = insert;
        return this;
    }

    public ColumnConfig setUpdate(String update) {
        this.update = update;
        return this;
    }

    public ColumnConfig setLarge(boolean isLarge) {
        this.isLarge = isLarge;
        return this;
    }

    public ColumnConfig setJdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
        return this;
    }

    public ColumnConfig setTypeHandler(Class<? extends TypeHandler> typeHandler) {
        this.typeHandler = typeHandler;
        return this;
    }

    public ColumnConfig setCategory(FieldType category) {
        this.category = category;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnConfig)) {
            return false;
        }
        ColumnConfig other = (ColumnConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLarge() != other.isLarge()) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$insert = this.getInsert();
        String other$insert = other.getInsert();
        if (this$insert == null ? other$insert != null : !this$insert.equals(other$insert)) {
            return false;
        }
        String this$update = this.getUpdate();
        String other$update = other.getUpdate();
        if (this$update == null ? other$update != null : !this$update.equals(other$update)) {
            return false;
        }
        TypeName this$javaType = this.getJavaType();
        TypeName other$javaType = other.getJavaType();
        if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
            return false;
        }
        JdbcType this$jdbcType = this.getJdbcType();
        JdbcType other$jdbcType = other.getJdbcType();
        if (this$jdbcType == null ? other$jdbcType != null : !this$jdbcType.equals(other$jdbcType)) {
            return false;
        }
        Class<? extends TypeHandler> this$typeHandler = this.getTypeHandler();
        Class<? extends TypeHandler> other$typeHandler = other.getTypeHandler();
        if (this$typeHandler == null ? other$typeHandler != null : !this$typeHandler.equals(other$typeHandler)) {
            return false;
        }
        FieldType this$category = this.getCategory();
        FieldType other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLarge() ? 79 : 97);
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $insert = this.getInsert();
        result = result * 59 + ($insert == null ? 43 : $insert.hashCode());
        String $update = this.getUpdate();
        result = result * 59 + ($update == null ? 43 : $update.hashCode());
        TypeName $javaType = this.getJavaType();
        result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
        JdbcType $jdbcType = this.getJdbcType();
        result = result * 59 + ($jdbcType == null ? 43 : $jdbcType.hashCode());
        Class<? extends TypeHandler> $typeHandler = this.getTypeHandler();
        result = result * 59 + ($typeHandler == null ? 43 : $typeHandler.hashCode());
        FieldType $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        return result;
    }

    public String toString() {
        return "ColumnConfig(column=" + this.getColumn() + ", field=" + this.getField() + ", insert=" + this.getInsert() + ", update=" + this.getUpdate() + ", isLarge=" + this.isLarge() + ", javaType=" + this.getJavaType() + ", jdbcType=" + this.getJdbcType() + ", typeHandler=" + this.getTypeHandler() + ", category=" + (Object)((Object)this.getCategory()) + ")";
    }
}

