/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.utils.json;

import com.fasc.open.api.exception.ApiException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JacksonUtil() {
    }

    public static String toJson(Object object) throws ApiException {
        try {
            if (object instanceof String) {
                JsonNode jsonNode = OBJECT_MAPPER.readTree(String.valueOf(object));
                return OBJECT_MAPPER.writeValueAsString((Object)jsonNode);
            }
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            log.error("toJson\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("toJson\u5931\u8d25");
        }
    }

    public static <T> T toJavaBean(String json, final ParameterizedType parameterizedType) throws ApiException {
        if (json == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, new TypeReference<T>(){

                public Type getType() {
                    return parameterizedType;
                }
            });
        }
        catch (JsonProcessingException e) {
            log.error("toJavaBean\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("toJavaBean\u5931\u8d25");
        }
    }

    public static <T> T toJavaBean(String json, Class<T> clzz) throws ApiException {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clzz);
        }
        catch (JsonProcessingException e) {
            log.error("toJavaBean\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("toJavaBean\u5931\u8d25");
        }
    }

    public static <T> List<T> toList(String json, Class<T> clzz) throws ApiException {
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{clzz});
        try {
            return (List)OBJECT_MAPPER.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            log.error("toList\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("toList\u5931\u8d25");
        }
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        OBJECT_MAPPER.enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        OBJECT_MAPPER.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        OBJECT_MAPPER.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
        OBJECT_MAPPER.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    }
}

