package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.req.smartform.*;
import com.fasc.open.api.v5_1.res.smartform.*;

import java.util.List;

/**
 * @author Fadada
 * 2023/06/14 16:48:09
 */
public class SmartFormClient {

    private OpenApiClient openApiClient;

    public SmartFormClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }


    public BaseRes<List<GetSmartFormListRes>> list(GetSmartFormListReq req) throws ApiException {
        return openApiClient.invokeApiList(req, OpenApiUrlConstants.SMART_FORM_GET_LIST, GetSmartFormListRes.class);
    }

    public BaseRes<GetSmartFormDetailRes> detail(GetSmartFormDetailReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SMART_FORM_GET_DETAIL, GetSmartFormDetailRes.class);
    }

    public BaseRes<List<GetSmartFormSerialInfoRes>> getSmartFormSerialInfo(GetSmartFormSerialInfoReq req) throws ApiException {
        return openApiClient.invokeApiList(req, OpenApiUrlConstants.SMART_FORM_SERIAL_GET_INFO, GetSmartFormSerialInfoRes.class);
    }

    public BaseRes<Void> deleteSmartForm(DeleteSmartFormReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SMART_FORM_DELETE, Void.class);
    }

    public BaseRes<Void> deleteSmartFormSerial(DeleteSmartFormSerialReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SMART_FORM_SERIAL_DELETE, Void.class);
    }

    public BaseRes<GetSmartFormManageUrlRes> getSmartFormManageUrl(GetSmartFormManageUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SMART_FORM_MANAGE_GET_URL, GetSmartFormManageUrlRes.class);
    }

    public BaseRes<GetSmartFormCollectUrlRes> getSmartFormCollectUrl(GetSmartFormCollectUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SMART_FORM_COLLECT_GET_URL, GetSmartFormCollectUrlRes.class);
    }
}
