/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.applicationinsights.fluent.AnnotationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.AnnotationInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsManagementClientImpl;
import com.azure.resourcemanager.applicationinsights.models.AnnotationErrorException;
import com.azure.resourcemanager.applicationinsights.models.AnnotationsListResult;
import java.util.List;
import reactor.core.publisher.Mono;

public final class AnnotationsClientImpl
implements AnnotationsClient {
    private final AnnotationsService service;
    private final ApplicationInsightsManagementClientImpl client;

    AnnotationsClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service = (AnnotationsService)RestProxy.create(AnnotationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AnnotationInner>> listSinglePageAsync(String resourceGroupName, String resourceName, String start, String end) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (start == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter start is required and cannot be null."));
        }
        if (end == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter end is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, start, end, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnnotationsListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AnnotationInner>> listSinglePageAsync(String resourceGroupName, String resourceName, String start, String end, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (start == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter start is required and cannot be null."));
        }
        if (end == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter end is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, start, end, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AnnotationsListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AnnotationInner> listAsync(String resourceGroupName, String resourceName, String start, String end) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName, start, end));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AnnotationInner> listAsync(String resourceGroupName, String resourceName, String start, String end, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName, start, end, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnnotationInner> list(String resourceGroupName, String resourceName, String start, String end) {
        return new PagedIterable(this.listAsync(resourceGroupName, resourceName, start, end));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnnotationInner> list(String resourceGroupName, String resourceName, String start, String end, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, resourceName, start, end, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<AnnotationInner>>> createWithResponseAsync(String resourceGroupName, String resourceName, AnnotationInner annotationProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (annotationProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter annotationProperties is required and cannot be null."));
        }
        annotationProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, annotationProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<AnnotationInner>>> createWithResponseAsync(String resourceGroupName, String resourceName, AnnotationInner annotationProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (annotationProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter annotationProperties is required and cannot be null."));
        }
        annotationProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, annotationProperties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<List<AnnotationInner>> createAsync(String resourceGroupName, String resourceName, AnnotationInner annotationProperties) {
        return this.createWithResponseAsync(resourceGroupName, resourceName, annotationProperties).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AnnotationInner> create(String resourceGroupName, String resourceName, AnnotationInner annotationProperties) {
        return (List)this.createAsync(resourceGroupName, resourceName, annotationProperties).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<AnnotationInner>> createWithResponse(String resourceGroupName, String resourceName, AnnotationInner annotationProperties, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, resourceName, annotationProperties, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String annotationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (annotationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter annotationId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, annotationId, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String annotationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (annotationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter annotationId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, annotationId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String annotationId) {
        return this.deleteWithResponseAsync(resourceGroupName, resourceName, annotationId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, String annotationId) {
        this.deleteAsync(resourceGroupName, resourceName, annotationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, String annotationId, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, resourceName, annotationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<AnnotationInner>>> getWithResponseAsync(String resourceGroupName, String resourceName, String annotationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (annotationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter annotationId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, annotationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<AnnotationInner>>> getWithResponseAsync(String resourceGroupName, String resourceName, String annotationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (annotationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter annotationId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, annotationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<List<AnnotationInner>> getAsync(String resourceGroupName, String resourceName, String annotationId) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, annotationId).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AnnotationInner> get(String resourceGroupName, String resourceName, String annotationId) {
        return (List)this.getAsync(resourceGroupName, resourceName, annotationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<AnnotationInner>> getWithResponse(String resourceGroupName, String resourceName, String annotationId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, annotationId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApplicationInsightsM")
    private static interface AnnotationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AnnotationErrorException.class)
        public Mono<Response<AnnotationsListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @QueryParam(value="start") String var6, @QueryParam(value="end") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AnnotationErrorException.class)
        public Mono<Response<List<AnnotationInner>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @BodyParam(value="application/json") AnnotationInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations/{annotationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="annotationId") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations/{annotationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=AnnotationErrorException.class)
        public Mono<Response<List<AnnotationInner>>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="annotationId") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

