/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.models.WebTestGeolocation;
import com.azure.resourcemanager.applicationinsights.models.WebTestKind;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class WebTestProperties {
    @JsonProperty(value="SyntheticMonitorId", required=true)
    private String syntheticMonitorId;
    @JsonProperty(value="Name", required=true)
    private String webTestName;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="Enabled")
    private Boolean enabled;
    @JsonProperty(value="Frequency")
    private Integer frequency;
    @JsonProperty(value="Timeout")
    private Integer timeout;
    @JsonProperty(value="Kind", required=true)
    private WebTestKind webTestKind;
    @JsonProperty(value="RetryEnabled")
    private Boolean retryEnabled;
    @JsonProperty(value="Locations", required=true)
    private List<WebTestGeolocation> locations;
    @JsonProperty(value="Configuration")
    private WebTestPropertiesConfiguration configuration;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(WebTestProperties.class);

    public String syntheticMonitorId() {
        return this.syntheticMonitorId;
    }

    public WebTestProperties withSyntheticMonitorId(String syntheticMonitorId) {
        this.syntheticMonitorId = syntheticMonitorId;
        return this;
    }

    public String webTestName() {
        return this.webTestName;
    }

    public WebTestProperties withWebTestName(String webTestName) {
        this.webTestName = webTestName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public WebTestProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public WebTestProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer frequency() {
        return this.frequency;
    }

    public WebTestProperties withFrequency(Integer frequency) {
        this.frequency = frequency;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public WebTestProperties withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public WebTestKind webTestKind() {
        return this.webTestKind;
    }

    public WebTestProperties withWebTestKind(WebTestKind webTestKind) {
        this.webTestKind = webTestKind;
        return this;
    }

    public Boolean retryEnabled() {
        return this.retryEnabled;
    }

    public WebTestProperties withRetryEnabled(Boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
        return this;
    }

    public List<WebTestGeolocation> locations() {
        return this.locations;
    }

    public WebTestProperties withLocations(List<WebTestGeolocation> locations) {
        this.locations = locations;
        return this;
    }

    public WebTestPropertiesConfiguration configuration() {
        return this.configuration;
    }

    public WebTestProperties withConfiguration(WebTestPropertiesConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.syntheticMonitorId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property syntheticMonitorId in model WebTestProperties"));
        }
        if (this.webTestName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property webTestName in model WebTestProperties"));
        }
        if (this.webTestKind() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property webTestKind in model WebTestProperties"));
        }
        if (this.locations() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property locations in model WebTestProperties"));
        }
        this.locations().forEach(e -> e.validate());
        if (this.configuration() != null) {
            this.configuration().validate();
        }
    }
}

