/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentProperties;
import com.azure.resourcemanager.applicationinsights.models.ApplicationType;
import com.azure.resourcemanager.applicationinsights.models.ComponentsResource;
import com.azure.resourcemanager.applicationinsights.models.FlowType;
import com.azure.resourcemanager.applicationinsights.models.IngestionMode;
import com.azure.resourcemanager.applicationinsights.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.applicationinsights.models.PublicNetworkAccessType;
import com.azure.resourcemanager.applicationinsights.models.RequestSource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ApplicationInsightsComponentInner
extends ComponentsResource {
    @JsonProperty(value="kind", required=true)
    private String kind;
    @JsonProperty(value="etag")
    private String etag;
    @JsonProperty(value="properties")
    private ApplicationInsightsComponentProperties innerProperties;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationInsightsComponentInner.class);

    public String kind() {
        return this.kind;
    }

    public ApplicationInsightsComponentInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public ApplicationInsightsComponentInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    private ApplicationInsightsComponentProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public ApplicationInsightsComponentInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public ApplicationInsightsComponentInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public String applicationId() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationId();
    }

    public String appId() {
        return this.innerProperties() == null ? null : this.innerProperties().appId();
    }

    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    public ApplicationType applicationType() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationType();
    }

    public ApplicationInsightsComponentInner withApplicationType(ApplicationType applicationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withApplicationType(applicationType);
        return this;
    }

    public FlowType flowType() {
        return this.innerProperties() == null ? null : this.innerProperties().flowType();
    }

    public ApplicationInsightsComponentInner withFlowType(FlowType flowType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withFlowType(flowType);
        return this;
    }

    public RequestSource requestSource() {
        return this.innerProperties() == null ? null : this.innerProperties().requestSource();
    }

    public ApplicationInsightsComponentInner withRequestSource(RequestSource requestSource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withRequestSource(requestSource);
        return this;
    }

    public String instrumentationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().instrumentationKey();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public String tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    public String hockeyAppId() {
        return this.innerProperties() == null ? null : this.innerProperties().hockeyAppId();
    }

    public ApplicationInsightsComponentInner withHockeyAppId(String hockeyAppId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withHockeyAppId(hockeyAppId);
        return this;
    }

    public String hockeyAppToken() {
        return this.innerProperties() == null ? null : this.innerProperties().hockeyAppToken();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Double samplingPercentage() {
        return this.innerProperties() == null ? null : this.innerProperties().samplingPercentage();
    }

    public ApplicationInsightsComponentInner withSamplingPercentage(Double samplingPercentage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withSamplingPercentage(samplingPercentage);
        return this;
    }

    public String connectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionString();
    }

    public Integer retentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionInDays();
    }

    public ApplicationInsightsComponentInner withRetentionInDays(Integer retentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withRetentionInDays(retentionInDays);
        return this;
    }

    public Boolean disableIpMasking() {
        return this.innerProperties() == null ? null : this.innerProperties().disableIpMasking();
    }

    public ApplicationInsightsComponentInner withDisableIpMasking(Boolean disableIpMasking) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withDisableIpMasking(disableIpMasking);
        return this;
    }

    public Boolean immediatePurgeDataOn30Days() {
        return this.innerProperties() == null ? null : this.innerProperties().immediatePurgeDataOn30Days();
    }

    public ApplicationInsightsComponentInner withImmediatePurgeDataOn30Days(Boolean immediatePurgeDataOn30Days) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withImmediatePurgeDataOn30Days(immediatePurgeDataOn30Days);
        return this;
    }

    public String workspaceResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().workspaceResourceId();
    }

    public ApplicationInsightsComponentInner withWorkspaceResourceId(String workspaceResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withWorkspaceResourceId(workspaceResourceId);
        return this;
    }

    public OffsetDateTime laMigrationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().laMigrationDate();
    }

    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkScopedResources();
    }

    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccessForIngestion();
    }

    public ApplicationInsightsComponentInner withPublicNetworkAccessForIngestion(PublicNetworkAccessType publicNetworkAccessForIngestion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withPublicNetworkAccessForIngestion(publicNetworkAccessForIngestion);
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccessForQuery();
    }

    public ApplicationInsightsComponentInner withPublicNetworkAccessForQuery(PublicNetworkAccessType publicNetworkAccessForQuery) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withPublicNetworkAccessForQuery(publicNetworkAccessForQuery);
        return this;
    }

    public IngestionMode ingestionMode() {
        return this.innerProperties() == null ? null : this.innerProperties().ingestionMode();
    }

    public ApplicationInsightsComponentInner withIngestionMode(IngestionMode ingestionMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withIngestionMode(ingestionMode);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public ApplicationInsightsComponentInner withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public Boolean forceCustomerStorageForProfiler() {
        return this.innerProperties() == null ? null : this.innerProperties().forceCustomerStorageForProfiler();
    }

    public ApplicationInsightsComponentInner withForceCustomerStorageForProfiler(Boolean forceCustomerStorageForProfiler) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationInsightsComponentProperties();
        }
        this.innerProperties().withForceCustomerStorageForProfiler(forceCustomerStorageForProfiler);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.kind() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property kind in model ApplicationInsightsComponentInner"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

