/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.executor;

import com.aizuda.snailjob.client.job.core.MapHandler;
import com.aizuda.snailjob.client.job.core.cache.JobExecutorInfoCache;
import com.aizuda.snailjob.client.job.core.dto.JobExecutorInfo;
import com.aizuda.snailjob.client.job.core.dto.MapArgs;
import com.aizuda.snailjob.client.job.core.dto.MergeReduceArgs;
import com.aizuda.snailjob.client.job.core.dto.ReduceArgs;
import com.aizuda.snailjob.client.job.core.executor.AbstractMapReduceExecutor;
import com.aizuda.snailjob.client.model.ExecuteResult;
import com.aizuda.snailjob.common.core.exception.SnailJobMapReduceException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class AnnotationMapReduceJobExecutor
extends AbstractMapReduceExecutor {
    @Override
    protected ExecuteResult doReduceExecute(ReduceArgs reduceArgs) {
        JobExecutorInfo jobExecutorInfo = JobExecutorInfoCache.get(reduceArgs.getExecutorInfo());
        if (Objects.isNull(jobExecutorInfo)) {
            throw new SnailJobMapReduceException("[{}] not found", (Object)reduceArgs.getExecutorInfo());
        }
        if (Objects.isNull(jobExecutorInfo.getReduceExecutor())) {
            throw new SnailJobMapReduceException("[{}] MapTask execution method not found. Please configure the @ReduceExecutor annotation", (Object)reduceArgs.getExecutorInfo());
        }
        Class<?>[] paramTypes = jobExecutorInfo.getReduceExecutor().getParameterTypes();
        if (paramTypes.length > 0) {
            return (ExecuteResult)ReflectionUtils.invokeMethod((Method)jobExecutorInfo.getReduceExecutor(), (Object)jobExecutorInfo.getExecutor(), (Object[])new Object[]{reduceArgs});
        }
        throw new SnailJobMapReduceException("[{}] ReduceTask execution method not found", (Object)reduceArgs.getExecutorInfo());
    }

    @Override
    protected ExecuteResult doMergeReduceExecute(MergeReduceArgs mergeReduceArgs) {
        JobExecutorInfo jobExecutorInfo = JobExecutorInfoCache.get(mergeReduceArgs.getExecutorInfo());
        if (Objects.isNull(jobExecutorInfo)) {
            throw new SnailJobMapReduceException("[{}] not found", (Object)mergeReduceArgs.getExecutorInfo());
        }
        Method mergeReduceExecutor = jobExecutorInfo.getMergeReduceExecutor();
        if (Objects.isNull(mergeReduceExecutor)) {
            throw new SnailJobMapReduceException("[{}] MapTask execution method not found. Please configure the @MergeReduceExecutor annotation", (Object)mergeReduceArgs.getExecutorInfo());
        }
        Class<?>[] paramTypes = mergeReduceExecutor.getParameterTypes();
        if (paramTypes.length > 0) {
            return (ExecuteResult)ReflectionUtils.invokeMethod((Method)mergeReduceExecutor, (Object)jobExecutorInfo.getExecutor(), (Object[])new Object[]{mergeReduceArgs});
        }
        throw new SnailJobMapReduceException("[{}] MergeReduceTask execution method not found [{}]", (Object)mergeReduceArgs.getExecutorInfo());
    }

    @Override
    public ExecuteResult doJobMapExecute(MapArgs mapArgs, MapHandler mapHandler) {
        return this.invokeMapExecute(mapArgs, mapHandler);
    }
}

