/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.appender;

import com.aizuda.snailjob.client.common.log.report.LogReportFactory;
import com.aizuda.snailjob.client.common.log.support.SnailJobLogManager;
import com.aizuda.snailjob.client.common.rpc.client.netty.NettyChannel;
import com.aizuda.snailjob.common.log.dto.LogContentDTO;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Throwables;
import org.slf4j.MDC;

@Plugin(name="SnailLog4j2Appender", category="Core", elementType="appender", printObject=true)
public class SnailLog4j2Appender
extends AbstractAppender {
    public void append(LogEvent event) {
        if (Objects.isNull(SnailJobLogManager.getLogMeta()) || Objects.isNull(MDC.get((String)"remote"))) {
            return;
        }
        MDC.remove((String)"remote");
        LogContentDTO logContentDTO = new LogContentDTO();
        logContentDTO.addTimeStamp(Long.valueOf(event.getTimeMillis()));
        logContentDTO.addLevelField(event.getLevel().name());
        logContentDTO.addThreadField(event.getThreadName());
        logContentDTO.addLocationField(this.getLocationField(event));
        logContentDTO.addThrowableField(this.getThrowableField(event));
        logContentDTO.addMessageField(event.getMessage().getFormattedMessage());
        logContentDTO.addHostField(NettyChannel.getClientHost());
        logContentDTO.addPortField(NettyChannel.getClientPort());
        Optional.ofNullable(LogReportFactory.get()).ifPresent(logReport -> logReport.report(logContentDTO));
    }

    protected SnailLog4j2Appender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    @PluginFactory
    public static SnailLog4j2Appender create(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginAttribute(value="timeFormat") String timeFormat, @PluginAttribute(value="timeZone") String timeZone) {
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)false);
        SnailLog4j2Appender log4j2Appender = new SnailLog4j2Appender(name, filter, layout, ignoreExceptions);
        return log4j2Appender;
    }

    private String getLocationField(LogEvent event) {
        StackTraceElement source = event.getSource();
        if (source == null && !event.isIncludeLocation()) {
            event.setIncludeLocation(true);
            source = event.getSource();
            event.setIncludeLocation(false);
        }
        return source == null ? "Unknown(Unknown Source)" : source.toString();
    }

    private String getThrowableField(LogEvent event) {
        String throwable = this.getThrowableStr(event.getThrown());
        if (throwable != null) {
            return throwable;
        }
        return null;
    }

    private String getThrowableStr(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        int stackDeep = 0;
        for (String s : Throwables.toStringList((Throwable)throwable)) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append(s);
            if (++stackDeep < 30) continue;
            break;
        }
        return sb.toString();
    }
}

