/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.pgvector;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.store.DocumentStore;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.store.pgvector.PgvectorUtil;
import com.agentsflex.store.pgvector.PgvectorVectorStoreConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.postgresql.ds.PGSimpleDataSource;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgvectorVectorStore
extends DocumentStore {
    private static final Logger logger = LoggerFactory.getLogger(PgvectorVectorStore.class);
    public static final double DEFAULT_SIMILARITY_THRESHOLD = 0.3;
    private final PGSimpleDataSource dataSource = new PGSimpleDataSource();
    private final String defaultCollectionName;
    private final PgvectorVectorStoreConfig config;

    public PgvectorVectorStore(PgvectorVectorStoreConfig config) {
        this.dataSource.setServerNames(new String[]{config.getHost() + ":" + config.getPort()});
        this.dataSource.setUser(config.getUsername());
        this.dataSource.setPassword(config.getPassword());
        this.dataSource.setDatabaseName(config.getDatabaseName());
        if (!config.getProperties().isEmpty()) {
            config.getProperties().forEach((k, v) -> {
                try {
                    this.dataSource.setProperty(k, v);
                }
                catch (SQLException e) {
                    logger.error("set pg property error", (Throwable)e);
                }
            });
        }
        this.defaultCollectionName = config.getDefaultCollectionName();
        this.config = config;
        new Thread(this::initDb).start();
    }

    public void initDb() {
        if (this.config.isAutoCreateCollection()) {
            this.createCollection(this.defaultCollectionName);
        }
    }

    private Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    public StoreResult storeInternal(List<Document> documents, StoreOptions options) {
        String collectionName = options.getCollectionNameOrDefault(this.defaultCollectionName);
        try (Connection connection = this.getConnection();){
            PreparedStatement pstmt = connection.prepareStatement("insert into " + collectionName + " (id, content, vector, metadata) values (?, ?, ?, ?::jsonb)");
            for (Document doc : documents) {
                Map metadatas = doc.getMetadataMap();
                JSONObject jsonObject = JSON.parseObject((byte[])JSON.toJSONBytes((Object)(metadatas == null ? Collections.EMPTY_MAP : metadatas)), (Feature[])new Feature[0]);
                pstmt.setString(1, String.valueOf(doc.getId()));
                pstmt.setString(2, doc.getContent());
                pstmt.setObject(3, PgvectorUtil.toPgVector(doc.getVector()));
                pstmt.setString(4, jsonObject.toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            connection.commit();
        }
        catch (SQLException e) {
            logger.error("store vector error", (Throwable)e);
            return StoreResult.fail();
        }
        return StoreResult.successWithIds(documents);
    }

    private Boolean createCollection(String collectionName) {
        block39: {
            try (Connection connection = this.getConnection();){
                try (CallableStatement statement = connection.prepareCall("CREATE TABLE IF NOT EXISTS " + collectionName + " (id varchar(100) PRIMARY KEY, content text, vector vector(" + this.config.getVectorDimension() + "), metadata jsonb)");){
                    statement.execute();
                }
                if (!this.config.isUseHnswIndex()) break block39;
                var5_8 = null;
                try (Statement stmt = connection.createStatement();){
                    stmt.execute("CREATE INDEX IF NOT EXISTS " + collectionName + "_vector_idx ON " + collectionName + " USING hnsw (vector vector_cosine_ops)");
                }
                catch (Throwable throwable) {
                    var5_8 = throwable;
                    throw throwable;
                }
            }
            catch (SQLException e) {
                logger.error("create collection error", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public StoreResult deleteInternal(Collection<?> ids, StoreOptions options) {
        StringBuilder sql = new StringBuilder("DELETE FROM " + options.getCollectionNameOrDefault(this.defaultCollectionName) + " WHERE id IN (");
        for (int i = 0; i < ids.size(); ++i) {
            sql.append("?");
            if (i >= ids.size() - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        try (Connection connection = this.getConnection();){
            PreparedStatement pstmt = connection.prepareStatement(sql.toString());
            ArrayList list = new ArrayList(ids);
            for (int i = 0; i < list.size(); ++i) {
                pstmt.setString(i + 1, (String)list.get(i));
            }
            pstmt.executeUpdate();
            connection.commit();
        }
        catch (Exception e) {
            logger.error("delete document error: " + e, (Throwable)e);
            return StoreResult.fail();
        }
        return StoreResult.success();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Document> searchInternal(SearchWrapper searchWrapper, StoreOptions options) {
        StringBuilder sql = new StringBuilder("select ");
        if (searchWrapper.isOutputVector()) {
            sql.append("id, vector, content, metadata");
        } else {
            sql.append("id,  content, metadata");
        }
        sql.append(" from ").append(options.getCollectionNameOrDefault(this.defaultCollectionName));
        sql.append(" where vector <=> ? < ? order by vector <=> ? LIMIT ?");
        try (Connection connection = this.getConnection();){
            PreparedStatement stmt = connection.prepareStatement(sql.toString());
            PGobject vector = PgvectorUtil.toPgVector(searchWrapper.getVector());
            stmt.setObject(1, vector);
            stmt.setObject(2, Optional.ofNullable(searchWrapper.getMinScore()).orElse(0.3));
            stmt.setObject(3, vector);
            stmt.setObject(4, searchWrapper.getMaxResults());
            ResultSet resultSet = stmt.executeQuery();
            ArrayList<Document> documents = new ArrayList<Document>();
            while (resultSet.next()) {
                Document doc = new Document();
                doc.setId((Object)resultSet.getString("id"));
                doc.setContent(resultSet.getString("content"));
                doc.addMetadata((Map)JSON.parseObject((String)resultSet.getString("metadata")));
                if (searchWrapper.isOutputVector()) {
                    String vectorStr = resultSet.getString("vector");
                    doc.setVector(PgvectorUtil.fromPgVector(vectorStr));
                }
                documents.add(doc);
            }
            ArrayList<Document> arrayList = documents;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("Error searching in pgvector", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public StoreResult updateInternal(List<Document> documents, StoreOptions options) {
        if (documents == null || documents.isEmpty()) {
            return StoreResult.success();
        }
        StringBuilder sql = new StringBuilder("UPDATE " + options.getCollectionNameOrDefault(this.defaultCollectionName) + " SET ");
        sql.append("content = ?, vector = ?, metadata = ?::jsonb WHERE id = ?");
        try (Connection connection = this.getConnection();){
            PreparedStatement pstmt = connection.prepareStatement(sql.toString());
            for (Document doc : documents) {
                Map metadatas = doc.getMetadataMap();
                JSONObject metadataJson = JSON.parseObject((byte[])JSON.toJSONBytes((Object)(metadatas == null ? Collections.EMPTY_MAP : metadatas)), (Feature[])new Feature[0]);
                pstmt.setString(1, doc.getContent());
                pstmt.setObject(2, PgvectorUtil.toPgVector(doc.getVector()));
                pstmt.setString(3, metadataJson.toString());
                pstmt.setString(4, String.valueOf(doc.getId()));
                pstmt.addBatch();
            }
            pstmt.executeUpdate();
            connection.commit();
        }
        catch (Exception e) {
            logger.error("Error update in pgvector", (Throwable)e);
            return StoreResult.fail();
        }
        return StoreResult.successWithIds(documents);
    }
}

