/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.opensearch;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.store.DocumentStore;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.store.exception.StoreException;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.store.opensearch.OpenSearchVectorStoreConfig;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch._types.InlineScript;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.TextProperty;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.ScriptScoreQuery;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Transport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchVectorStore
extends DocumentStore {
    private static final Logger log = LoggerFactory.getLogger(OpenSearchVectorStore.class);
    private final OpenSearchClient client;
    private final OpenSearchVectorStoreConfig config;

    public OpenSearchVectorStore(OpenSearchVectorStoreConfig config) {
        HttpHost openSearchHost;
        this.config = config;
        try {
            openSearchHost = HttpHost.create((String)config.getServerUrl());
        }
        catch (URISyntaxException se) {
            log.error("[OpenSearch Exception]", (Throwable)se);
            throw new StoreException(se.getMessage());
        }
        try {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (chains, authType) -> true).build();
            TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(sslContext).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
            ApacheHttpClient5Transport transport = ApacheHttpClient5TransportBuilder.builder((HttpHost[])new HttpHost[]{openSearchHost}).setMapper((JsonpMapper)new JacksonJsonpMapper()).setHttpClientConfigCallback(httpClientBuilder -> {
                if (StringUtil.hasText((String)config.getApiKey())) {
                    httpClientBuilder.setDefaultHeaders(Collections.singletonList(new BasicHeader("Authorization", (Object)("ApiKey " + config.getApiKey()))));
                }
                if (StringUtil.hasText((String)config.getUsername()) && StringUtil.hasText((String)config.getPassword())) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(new AuthScope(openSearchHost), (Credentials)new UsernamePasswordCredentials(config.getUsername(), config.getPassword().toCharArray()));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                httpClientBuilder.setConnectionManager((AsyncClientConnectionManager)PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build());
                return httpClientBuilder;
            }).build();
            this.client = new OpenSearchClient((OpenSearchTransport)transport);
            try {
                this.client.ping();
            }
            catch (IOException e) {
                log.error("[I/O OpenSearch Exception]", (Throwable)e);
                throw new StoreException(e.getMessage());
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new StoreException("OpenSearchClient init error", (Throwable)e);
        }
    }

    public OpenSearchVectorStore(OpenSearchVectorStoreConfig config, OpenSearchClient client) {
        this.config = config;
        this.client = client;
    }

    private void createIndexIfNotExist(String indexName) {
        try {
            BooleanResponse response = this.client.indices().exists(c -> c.index(indexName, new String[0]));
            if (!response.value()) {
                log.info("[OpenSearch] Index {} not exists, creating...", (Object)indexName);
                this.client.indices().create(c -> c.index(indexName).settings(s -> s.knn(Boolean.valueOf(true))).mappings(this.getDefaultMappings(this.getEmbeddingModel().dimensions())));
            }
        }
        catch (IOException e) {
            log.error("[I/O OpenSearch Exception]", (Throwable)e);
            throw new StoreException(e.getMessage());
        }
    }

    private TypeMapping getDefaultMappings(int dimension) {
        HashMap<String, Property> properties = new HashMap<String, Property>(4);
        properties.put("content", Property.of(p -> p.text(TextProperty.of(t -> t))));
        properties.put("vector", Property.of(p -> p.knnVector(k -> k.dimension(dimension))));
        return TypeMapping.of(c -> c.properties(properties));
    }

    public StoreResult storeInternal(List<Document> documents, StoreOptions options) {
        BulkRequest.Builder bulkBuilder = new BulkRequest.Builder();
        String indexName = options.getIndexNameOrDefault(this.config.getDefaultIndexName());
        this.createIndexIfNotExist(indexName);
        for (Document document : documents) {
            bulkBuilder.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(indexName)).id(document.getId().toString())).document((Object)document)));
        }
        this.bulk(bulkBuilder.build());
        return StoreResult.successWithIds(documents);
    }

    private void bulk(BulkRequest bulkRequest) {
        try {
            BulkResponse bulkResponse = this.client.bulk(bulkRequest);
            OpenSearchVectorStore.throwIfError(bulkResponse);
        }
        catch (IOException e) {
            log.error("[I/O OpenSearch Exception]", (Throwable)e);
            throw new StoreException(e.getMessage());
        }
    }

    private static void throwIfError(BulkResponse bulkResponse) {
        if (bulkResponse.errors()) {
            for (BulkResponseItem item : bulkResponse.items()) {
                if (item.error() == null) continue;
                ErrorCause errorCause = item.error();
                throw new StoreException("type: " + errorCause.type() + ",reason: " + errorCause.reason());
            }
        }
    }

    public StoreResult deleteInternal(Collection<?> ids, StoreOptions options) {
        String indexName = options.getIndexNameOrDefault(this.config.getDefaultIndexName());
        BulkRequest.Builder bulkBuilder = new BulkRequest.Builder();
        for (Object id : ids) {
            bulkBuilder.operations(op -> op.delete(d -> (DeleteOperation.Builder)((DeleteOperation.Builder)d.index(indexName)).id(id.toString())));
        }
        this.bulk(bulkBuilder.build());
        return StoreResult.success();
    }

    public StoreResult updateInternal(List<Document> documents, StoreOptions options) {
        BulkRequest.Builder bulkBuilder = new BulkRequest.Builder();
        String indexName = options.getIndexNameOrDefault(this.config.getDefaultIndexName());
        for (Document document : documents) {
            bulkBuilder.operations(op -> op.update(idx -> ((UpdateOperation.Builder)((UpdateOperation.Builder)idx.index(indexName)).id(document.getId().toString())).document((Object)document)));
        }
        this.bulk(bulkBuilder.build());
        return StoreResult.successWithIds(documents);
    }

    public List<Document> searchInternal(SearchWrapper wrapper, StoreOptions options) {
        Double minScore = wrapper.getMinScore();
        String indexName = options.getIndexNameOrDefault(this.config.getDefaultIndexName());
        ScriptScoreQuery scriptScoreQuery = ScriptScoreQuery.of(q -> q.minScore(Float.valueOf(minScore == null ? 0.0f : minScore.floatValue())).query(Query.of(qu -> qu.matchAll(m -> m))).script(s -> s.inline(InlineScript.of(i -> (InlineScript.Builder)((InlineScript.Builder)((InlineScript.Builder)i.source("knn_score").lang("knn").params("field", JsonData.of((Object)"vector"))).params("query_value", JsonData.of((Object)wrapper.getVector()))).params("space_type", JsonData.of((Object)"cosinesimil"))))));
        try {
            SearchResponse response = this.client.search(SearchRequest.of(s -> s.index(indexName, new String[0]).query(n -> n.scriptScore(scriptScoreQuery)).size(wrapper.getMaxResults())), Document.class);
            return response.hits().hits().stream().filter(s -> s.source() != null).map(s -> {
                Document source = (Document)s.source();
                source.setScore(s.score());
                return source;
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            log.error("[I/O OpenSearch Exception]", (Throwable)e);
            throw new StoreException(e.getMessage());
        }
    }
}

