/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.milvus;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.store.DocumentStore;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.store.condition.ExpressionAdaptor;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.core.util.VectorUtil;
import com.agentsflex.store.milvus.MilvusExpressionAdaptor;
import com.agentsflex.store.milvus.MilvusVectorStoreConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.client.MilvusClientV2;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.common.DataType;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.GetLoadStateReq;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusVectorStore
extends DocumentStore {
    private static final Logger logger = LoggerFactory.getLogger(MilvusVectorStore.class);
    private final MilvusClientV2 client;
    private final String defaultCollectionName;
    private final MilvusVectorStoreConfig config;

    public MilvusVectorStore(MilvusVectorStoreConfig config) {
        ConnectConfig connectConfig = ConnectConfig.builder().uri(config.getUri()).dbName(config.getDatabaseName()).token(config.getToken()).username(config.getUsername()).password(config.getPassword()).build();
        this.client = new MilvusClientV2(connectConfig);
        this.defaultCollectionName = config.getDefaultCollectionName();
        this.config = config;
    }

    public StoreResult storeInternal(List<Document> documents, StoreOptions options) {
        Object metadatas;
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        for (Document doc : documents) {
            JSONObject dict = new JSONObject();
            dict.put("id", (Object)String.valueOf(doc.getId()));
            dict.put("content", (Object)doc.getContent());
            dict.put("vector", (Object)VectorUtil.toFloatList((double[])doc.getVector()));
            metadatas = doc.getMetadataMap();
            JSONObject jsonObject = JSON.parseObject((byte[])JSON.toJSONBytes((Object)(metadatas == null ? Collections.EMPTY_MAP : metadatas)), (Feature[])new Feature[0]);
            dict.put("metadata", (Object)jsonObject);
            data.add(dict);
        }
        String collectionName = options.getCollectionNameOrDefault(this.defaultCollectionName);
        InsertReq.InsertReqBuilder builder = InsertReq.builder();
        if (StringUtil.hasText((String)options.getPartitionName())) {
            builder.partitionName(options.getPartitionName());
        }
        InsertReq insertReq = builder.collectionName(collectionName).data(data).build();
        try {
            metadatas = this.client.insert(insertReq);
        }
        catch (MilvusClientException e) {
            if (e.getMessage() != null && e.getMessage().contains("collection not found") && this.config.isAutoCreateCollection() && options.getMetadata("forInternal") == null) {
                Boolean success = this.createCollection(collectionName);
                if (success != null && success.booleanValue()) {
                    options.addMetadata("forInternal", (Object)true);
                    this.storeInternal(documents, options);
                }
            }
            return StoreResult.fail();
        }
        return StoreResult.successWithIds(documents);
    }

    private Boolean createCollection(String collectionName) {
        ArrayList<CreateCollectionReq.FieldSchema> fieldSchemaList = new ArrayList<CreateCollectionReq.FieldSchema>();
        CreateCollectionReq.FieldSchema id = CreateCollectionReq.FieldSchema.builder().name("id").dataType(DataType.VarChar).maxLength(Integer.valueOf(36)).isPrimaryKey(Boolean.valueOf(true)).autoID(Boolean.valueOf(false)).build();
        fieldSchemaList.add(id);
        CreateCollectionReq.FieldSchema content = CreateCollectionReq.FieldSchema.builder().name("content").dataType(DataType.VarChar).maxLength(Integer.valueOf(65535)).build();
        fieldSchemaList.add(content);
        CreateCollectionReq.FieldSchema metadata = CreateCollectionReq.FieldSchema.builder().name("metadata").dataType(DataType.JSON).build();
        fieldSchemaList.add(metadata);
        CreateCollectionReq.FieldSchema vector = CreateCollectionReq.FieldSchema.builder().name("vector").dataType(DataType.FloatVector).dimension(Integer.valueOf(this.getEmbeddingModel().dimensions())).build();
        fieldSchemaList.add(vector);
        CreateCollectionReq.CollectionSchema collectionSchema = CreateCollectionReq.CollectionSchema.builder().fieldSchemaList(fieldSchemaList).build();
        ArrayList<IndexParam> indexParams = new ArrayList<IndexParam>();
        IndexParam vectorIndex = IndexParam.builder().fieldName("vector").indexType(IndexParam.IndexType.IVF_FLAT).metricType(IndexParam.MetricType.COSINE).indexName("vector").extraParams((Map)Maps.of((String)"nlist", (Object)1024)).build();
        indexParams.add(vectorIndex);
        CreateCollectionReq createCollectionReq = CreateCollectionReq.builder().collectionName(collectionName).collectionSchema(collectionSchema).primaryFieldName("id").vectorFieldName("vector").description("Agents Flex Vector Store").indexParams(indexParams).build();
        this.client.createCollection(createCollectionReq);
        GetLoadStateReq quickSetupLoadStateReq = GetLoadStateReq.builder().collectionName(collectionName).build();
        return this.client.getLoadState(quickSetupLoadStateReq);
    }

    public StoreResult deleteInternal(Collection<?> ids, StoreOptions options) {
        DeleteReq.DeleteReqBuilder builder = DeleteReq.builder();
        if (StringUtil.hasText((String)options.getPartitionName())) {
            builder.partitionName(options.getPartitionName());
        }
        DeleteReq deleteReq = builder.collectionName(options.getCollectionNameOrDefault(this.defaultCollectionName)).ids(new ArrayList(ids)).build();
        try {
            this.client.delete(deleteReq);
        }
        catch (Exception e) {
            logger.error("delete document error: " + e, (Throwable)e);
            return StoreResult.fail();
        }
        return StoreResult.success();
    }

    public List<Document> searchInternal(SearchWrapper searchWrapper, StoreOptions options) {
        List<String> outputFields;
        List<String> list = outputFields = searchWrapper.isOutputVector() ? Arrays.asList("id", "vector", "content", "metadata") : Arrays.asList("id", "content", "metadata");
        if (searchWrapper.getVector() != null && searchWrapper.getVector().length > 0) {
            SearchReq.SearchReqBuilder builder = SearchReq.builder();
            if (StringUtil.hasText((String)options.getPartitionName())) {
                builder.partitionNames(options.getPartitionNamesOrEmpty());
            }
            SearchReq searchReq = builder.collectionName(options.getCollectionNameOrDefault(this.defaultCollectionName)).consistencyLevel(ConsistencyLevel.STRONG).outputFields(outputFields).topK(searchWrapper.getMaxResults().intValue()).annsField("vector").data(Collections.singletonList(VectorUtil.toFloatList((double[])searchWrapper.getVector()))).filter(searchWrapper.toFilterExpression((ExpressionAdaptor)MilvusExpressionAdaptor.DEFAULT)).build();
            try {
                SearchResp resp = this.client.search(searchReq);
                List results = resp.getSearchResults();
                ArrayList<Document> documents = new ArrayList<Document>();
                for (List resultList : results) {
                    for (SearchResp.SearchResult result : resultList) {
                        Map entity = result.getEntity();
                        if (entity == null || entity.isEmpty()) continue;
                        Document doc = new Document();
                        doc.setId(result.getId());
                        Object vectorObj = entity.get("vector");
                        if (vectorObj instanceof List) {
                            doc.setVector(VectorUtil.convertToVector((List)((List)vectorObj)));
                        }
                        doc.setContent((String)entity.get("content"));
                        Float distance = result.getDistance();
                        if (distance != null) {
                            double score = (distance.floatValue() + 1.0f) / 2.0f;
                            doc.setScore(Double.valueOf(score));
                        }
                        JSONObject object = (JSONObject)entity.get("metadata");
                        doc.addMetadata((Map)object);
                        documents.add(doc);
                    }
                }
                return documents;
            }
            catch (Exception e) {
                logger.error("Error searching in Milvus", (Throwable)e);
                return Collections.emptyList();
            }
        }
        QueryReq.QueryReqBuilder builder = QueryReq.builder();
        if (StringUtil.hasText((String)options.getPartitionName())) {
            builder.partitionNames(options.getPartitionNamesOrEmpty());
        }
        QueryReq queryReq = builder.collectionName(options.getCollectionNameOrDefault(this.defaultCollectionName)).consistencyLevel(ConsistencyLevel.STRONG).outputFields(outputFields).filter(searchWrapper.toFilterExpression((ExpressionAdaptor)MilvusExpressionAdaptor.DEFAULT)).build();
        try {
            QueryResp resp = this.client.query(queryReq);
            List results = resp.getQueryResults();
            ArrayList<Document> documents = new ArrayList<Document>();
            for (QueryResp.QueryResult result : results) {
                Map entity = result.getEntity();
                if (entity == null || entity.isEmpty()) continue;
                Document doc = new Document();
                doc.setId(result.getEntity().get("id"));
                Object vectorObj = entity.get("vector");
                if (vectorObj instanceof List) {
                    doc.setVector(VectorUtil.convertToVector((List)((List)vectorObj)));
                }
                doc.setContent((String)entity.get("content"));
                JSONObject object = (JSONObject)entity.get("metadata");
                doc.addMetadata((Map)object);
                documents.add(doc);
            }
            return documents;
        }
        catch (Exception e) {
            logger.error("Error querying in Milvus", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public StoreResult updateInternal(List<Document> documents, StoreOptions options) {
        if (documents == null || documents.isEmpty()) {
            return StoreResult.success();
        }
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        for (Document doc : documents) {
            JSONObject dict = new JSONObject();
            dict.put("id", (Object)String.valueOf(doc.getId()));
            dict.put("content", (Object)doc.getContent());
            dict.put("vector", (Object)VectorUtil.toFloatList((double[])doc.getVector()));
            Map metadatas = doc.getMetadataMap();
            JSONObject jsonObject = JSON.parseObject((byte[])JSON.toJSONBytes((Object)(metadatas == null ? Collections.EMPTY_MAP : metadatas)), (Feature[])new Feature[0]);
            dict.put("metadata", (Object)jsonObject);
            data.add(dict);
        }
        UpsertReq upsertReq = UpsertReq.builder().collectionName(options.getCollectionNameOrDefault(this.defaultCollectionName)).partitionName(options.getPartitionName()).data(data).build();
        this.client.upsert(upsertReq);
        return StoreResult.successWithIds(documents);
    }

    public MilvusClientV2 getClient() {
        return this.client;
    }
}

