/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.mapping.DenseVectorProperty;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.TextProperty;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.ScriptScoreQuery;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.agentsflex.core.document.Document;
import com.agentsflex.core.store.DocumentStore;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.store.exception.StoreException;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.store.elasticsearch.ElasticSearchVectorStoreConfig;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchVectorStore
extends DocumentStore {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchVectorStore.class);
    private final ElasticsearchClient client;
    private final ElasticSearchVectorStoreConfig config;

    public ElasticSearchVectorStore(ElasticSearchVectorStoreConfig config) {
        this.config = config;
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)config.getServerUrl())});
        try {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (chains, authType) -> true).build();
            if (StringUtil.hasText((String)config.getUsername())) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.getUsername(), config.getPassword()));
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticSearchVectorStore.lambda$new$1(sslContext, (CredentialsProvider)provider, arg_0));
            }
            if (StringUtil.hasText((String)config.getApiKey())) {
                restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "Apikey " + config.getApiKey())});
            }
            RestClientTransport transport = new RestClientTransport(restClientBuilder.build(), (JsonpMapper)new JacksonJsonpMapper());
            this.client = new ElasticsearchClient((ElasticsearchTransport)transport);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new StoreException("Elasticsearch init error", (Throwable)e);
        }
        try {
            this.client.ping();
        }
        catch (IOException e) {
            log.error("[I/O Elasticsearch Exception]", (Throwable)e);
            throw new StoreException(e.getMessage());
        }
    }

    public ElasticSearchVectorStore(ElasticSearchVectorStoreConfig config, ElasticsearchClient client) {
        this.config = config;
        this.client = client;
    }

    private static void throwIfError(BulkResponse bulkResponse) {
        if (bulkResponse.errors()) {
            for (BulkResponseItem item : bulkResponse.items()) {
                if (item.error() == null) continue;
                ErrorCause errorCause = item.error();
                throw new StoreException("type: " + errorCause.type() + ",reason: " + errorCause.reason());
            }
        }
    }

    public StoreResult storeInternal(List<Document> documents, StoreOptions options) {
        String indexName = StringUtil.hasText((String)options.getCollectionName()) ? options.getCollectionName() : options.getIndexNameOrDefault(this.config.getDefaultIndexName());
        this.createIndexIfNotExist(indexName);
        return this.saveOrUpdate(documents, indexName);
    }

    public StoreResult deleteInternal(Collection<?> ids, StoreOptions options) {
        String indexName = options.getIndexNameOrDefault(this.config.getDefaultIndexName());
        BulkRequest.Builder bulkBuilder = new BulkRequest.Builder();
        for (Object id : ids) {
            bulkBuilder.operations(op -> op.delete(d -> (DeleteOperation.Builder)((DeleteOperation.Builder)d.index(indexName)).id(id.toString())));
        }
        this.bulk(bulkBuilder.build());
        return StoreResult.success();
    }

    public StoreResult updateInternal(List<Document> documents, StoreOptions options) {
        String indexName = options.getIndexNameOrDefault(this.config.getDefaultIndexName());
        return this.saveOrUpdate(documents, indexName);
    }

    public List<Document> searchInternal(SearchWrapper wrapper, StoreOptions options) {
        Double minScore = wrapper.getMinScore();
        String indexName = options.getIndexNameOrDefault(this.config.getDefaultIndexName());
        ScriptScoreQuery scriptScoreQuery = ScriptScoreQuery.of(fn -> fn.minScore(Float.valueOf(minScore == null ? 0.0f : minScore.floatValue())).query(Query.of(q -> q.matchAll(m -> m))).script(s -> s.source("(cosineSimilarity(params.query_vector, 'vector') + 1.0) / 2").params("query_vector", JsonData.of((Object)wrapper.getVector()))));
        try {
            SearchResponse response = this.client.search(SearchRequest.of(s -> s.index(indexName, new String[0]).query(n -> n.scriptScore(scriptScoreQuery)).size(wrapper.getMaxResults())), Document.class);
            return response.hits().hits().stream().filter(s -> s.source() != null).map(s -> {
                Document source = (Document)s.source();
                source.setScore(s.score());
                return source;
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            log.error("[I/O Elasticsearch Exception]", (Throwable)e);
            throw new StoreException(e.getMessage());
        }
    }

    private StoreResult saveOrUpdate(List<Document> documents, String indexName) {
        BulkRequest.Builder bulkBuilder = new BulkRequest.Builder();
        for (Document document : documents) {
            bulkBuilder.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(indexName)).id(document.getId().toString())).document((Object)document)));
        }
        this.bulk(bulkBuilder.build());
        return StoreResult.successWithIds(documents);
    }

    private void bulk(BulkRequest bulkRequest) {
        try {
            BulkResponse bulkResponse = this.client.bulk(bulkRequest);
            ElasticSearchVectorStore.throwIfError(bulkResponse);
        }
        catch (IOException e) {
            log.error("[I/O Elasticsearch Exception]", (Throwable)e);
            throw new StoreException(e.getMessage());
        }
    }

    private void createIndexIfNotExist(String indexName) {
        try {
            BooleanResponse response = this.client.indices().exists(c -> c.index(indexName, new String[0]));
            if (!response.value()) {
                log.info("[ElasticSearch] Index {} not exists, creating...", (Object)indexName);
                this.client.indices().create(c -> c.index(indexName).mappings(this.getDefaultMappings(this.getEmbeddingModel().dimensions())));
            }
        }
        catch (IOException e) {
            log.error("[I/O ElasticSearch Exception]", (Throwable)e);
            throw new StoreException(e.getMessage());
        }
    }

    private TypeMapping getDefaultMappings(int dimension) {
        HashMap<String, Property> properties = new HashMap<String, Property>(4);
        properties.put("content", Property.of(p -> p.text(TextProperty.of(t -> t))));
        properties.put("vector", Property.of(p -> p.denseVector(DenseVectorProperty.of(d -> d.dims(Integer.valueOf(dimension))))));
        return TypeMapping.of(c -> c.properties(properties));
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$new$1(SSLContext sslContext, CredentialsProvider provider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setSSLContext(sslContext);
        httpClientBuilder.setDefaultCredentialsProvider(provider);
        return httpClientBuilder;
    }
}

