/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.chroma;

import com.agentsflex.core.store.condition.Condition;
import com.agentsflex.core.store.condition.ConditionType;
import com.agentsflex.core.store.condition.ExpressionAdaptor;
import com.agentsflex.core.store.condition.Value;
import java.util.StringJoiner;

public class ChromaExpressionAdaptor
implements ExpressionAdaptor {
    public static final ChromaExpressionAdaptor DEFAULT = new ChromaExpressionAdaptor();

    public String toOperationSymbol(ConditionType type) {
        if (type == ConditionType.EQ) {
            return " == ";
        }
        if (type == ConditionType.NE) {
            return " != ";
        }
        if (type == ConditionType.GT) {
            return " > ";
        }
        if (type == ConditionType.GE) {
            return " >= ";
        }
        if (type == ConditionType.LT) {
            return " < ";
        }
        if (type == ConditionType.LE) {
            return " <= ";
        }
        if (type == ConditionType.IN) {
            return " IN ";
        }
        return type.getDefaultSymbol();
    }

    public String toCondition(Condition condition) {
        if (condition.getType() == ConditionType.BETWEEN) {
            Object[] values = (Object[])((Value)condition.getRight()).getValue();
            return "(" + this.toLeft(condition.getLeft()) + this.toOperationSymbol(ConditionType.GE) + values[0] + " && " + this.toLeft(condition.getLeft()) + this.toOperationSymbol(ConditionType.LE) + values[1] + ")";
        }
        return super.toCondition(condition);
    }

    public String toValue(Condition condition, Object value) {
        if (value == null) {
            return "null";
        }
        if (condition.getType() == ConditionType.IN) {
            Object[] values = (Object[])value;
            StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
            for (Object v : values) {
                if (v == null) continue;
                stringJoiner.add("\"" + v + "\"");
            }
            return stringJoiner.toString();
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return super.toValue(condition, value);
    }

    public String toLeft(Object left) {
        if (left instanceof String) {
            String field = (String)left;
            if (field.contains(".")) {
                return field;
            }
            return field;
        }
        return left.toString();
    }
}

