/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.search.engine.lucene;

import com.agentsflex.core.document.Document;
import com.agentsflex.search.engine.lucene.LuceneConfig;
import com.agentsflex.search.engine.service.DocumentSearcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.jetbrains.annotations.NotNull;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.analyzer.JcsegAnalyzer;
import org.lionsoul.jcseg.dic.DictionaryFactory;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSearcher
implements DocumentSearcher {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneSearcher.class);
    private Directory directory;

    public LuceneSearcher(LuceneConfig config) {
        Objects.requireNonNull(config, "LuceneConfig \u4e0d\u80fd\u4e3a null");
        try {
            String indexDirPath = config.getIndexDirPath();
            File indexDir = new File(indexDirPath);
            if (!indexDir.exists() && !indexDir.mkdirs()) {
                throw new IllegalStateException("can not mkdirs for path: " + indexDirPath);
            }
            this.directory = FSDirectory.open((Path)indexDir.toPath());
        }
        catch (IOException e) {
            LOG.error("\u521d\u59cb\u5316 Lucene \u7d22\u5f15\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDocument(Document document) {
        if (document == null || document.getContent() == null) {
            return false;
        }
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.createIndexWriter();
            org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
            luceneDoc.add((IndexableField)new StringField("id", document.getId().toString(), Field.Store.YES));
            luceneDoc.add((IndexableField)new TextField("content", document.getContent(), Field.Store.YES));
            if (document.getTitle() != null) {
                luceneDoc.add((IndexableField)new TextField("title", document.getTitle(), Field.Store.YES));
            }
            indexWriter.addDocument((Iterable)luceneDoc);
            indexWriter.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("\u6dfb\u52a0\u6587\u6863\u5931\u8d25", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(indexWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDocument(Object id) {
        if (id == null) {
            return false;
        }
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.createIndexWriter();
            Term term = new Term("id", id.toString());
            indexWriter.deleteDocuments(new Term[]{term});
            indexWriter.commit();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("\u5220\u9664\u6587\u6863\u5931\u8d25", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(indexWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDocument(Document document) {
        if (document == null || document.getId() == null) {
            return false;
        }
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.createIndexWriter();
            Term term = new Term("id", document.getId().toString());
            org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
            luceneDoc.add((IndexableField)new StringField("id", document.getId().toString(), Field.Store.YES));
            luceneDoc.add((IndexableField)new TextField("content", document.getContent(), Field.Store.YES));
            if (document.getTitle() != null) {
                luceneDoc.add((IndexableField)new TextField("title", document.getTitle(), Field.Store.YES));
            }
            indexWriter.updateDocument(term, (Iterable)luceneDoc);
            indexWriter.commit();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("\u66f4\u65b0\u6587\u6863\u5931\u8d25", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(indexWriter);
        }
    }

    public List<Document> searchDocuments(String keyword, int count) {
        ArrayList<Document> results = new ArrayList<Document>();
        try (DirectoryReader reader = DirectoryReader.open((Directory)this.directory);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            Query query = LuceneSearcher.buildQuery(keyword);
            TopDocs topDocs = searcher.search(query, count);
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                org.apache.lucene.document.Document doc = searcher.doc(scoreDoc.doc);
                Document resultDoc = new Document();
                resultDoc.setId((Object)doc.get("id"));
                resultDoc.setContent(doc.get("content"));
                resultDoc.setTitle(doc.get("title"));
                resultDoc.setScore(Double.valueOf(scoreDoc.score));
                results.add(resultDoc);
            }
        }
        catch (Exception e) {
            LOG.error("\u641c\u7d22\u6587\u6863\u5931\u8d25", (Throwable)e);
        }
        return results;
    }

    private static Query buildQuery(String keyword) {
        try {
            Analyzer analyzer = LuceneSearcher.createAnalyzer();
            QueryParser titleQueryParser = new QueryParser("title", analyzer);
            Query titleQuery = titleQueryParser.parse(keyword);
            BooleanClause titleBooleanClause = new BooleanClause(titleQuery, BooleanClause.Occur.SHOULD);
            QueryParser contentQueryParser = new QueryParser("content", analyzer);
            Query contentQuery = contentQueryParser.parse(keyword);
            BooleanClause contentBooleanClause = new BooleanClause(contentQuery, BooleanClause.Occur.SHOULD);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(titleBooleanClause).add(contentBooleanClause);
            return builder.build();
        }
        catch (ParseException e) {
            LOG.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    private IndexWriter createIndexWriter() throws IOException {
        Analyzer analyzer = LuceneSearcher.createAnalyzer();
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(analyzer);
        return new IndexWriter(this.directory, indexWriterConfig);
    }

    private static Analyzer createAnalyzer() {
        SegmenterConfig config = new SegmenterConfig(true);
        return new JcsegAnalyzer(ISegment.Type.NLP, config, DictionaryFactory.createSingletonDictionary((SegmenterConfig)config));
    }

    public void close(IndexWriter indexWriter) {
        try {
            if (indexWriter != null) {
                indexWriter.close();
            }
        }
        catch (IOException e) {
            LOG.error("\u5173\u95ed Lucene \u5931\u8d25", (Throwable)e);
        }
    }
}

