/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.rerank;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.rerank.BaseRerankModel;
import com.agentsflex.core.llm.rerank.RerankConfig;
import com.agentsflex.core.llm.rerank.RerankException;
import com.agentsflex.core.llm.rerank.RerankOptions;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.rerank.DefaultRerankModelConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class DefaultRerankModel
extends BaseRerankModel<DefaultRerankModelConfig> {
    private HttpClient httpClient = new HttpClient();

    public DefaultRerankModel(DefaultRerankModelConfig config) {
        super((RerankConfig)config);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public List<Document> rerank(String query, List<Document> documents, RerankOptions options) {
        DefaultRerankModelConfig config = (DefaultRerankModelConfig)this.getConfig();
        String url = config.getEndpoint() + config.getBasePath();
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + config.getApiKey());
        ArrayList<String> payloadDocuments = new ArrayList<String>(documents.size());
        for (Document document : documents) {
            payloadDocuments.add(document.getContent());
        }
        String payload = Maps.of((String)"model", (Object)options.getModelOrDefault(config.getModel())).set("query", (Object)query).set("documents", payloadDocuments).toJSON();
        if (config.isDebug()) {
            LogUtil.println((String)(">>>>send payload:" + payload));
        }
        String response = this.httpClient.post(url, headers, payload);
        if (config.isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            throw new RerankException("empty response");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONArray results = (JSONArray)JSONPath.eval((Object)jsonObject, (String)config.getResultsJsonPath());
        if (results == null || results.isEmpty()) {
            throw new RerankException("empty results");
        }
        for (int i = 0; i < results.size(); ++i) {
            JSONObject result = results.getJSONObject(i);
            int index = result.getIntValue(config.getIndexJsonKey());
            Document document = documents.get(index);
            document.setScore(Double.valueOf(result.getDoubleValue(config.getScoreJsonKey())));
        }
        documents.sort(Comparator.comparingDouble(Document::getScore).reversed());
        return documents;
    }
}

