/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.qwen;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.MessageUtil;
import com.agentsflex.llm.qwen.QwenChatOptions;
import com.agentsflex.llm.qwen.QwenLlmConfig;
import java.util.List;
import java.util.Optional;

public class QwenLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat();

    public static AiMessageParser getAiMessageParser(boolean isStream) {
        return DefaultAiMessageParser.getChatGPTMessageParser((boolean)isStream);
    }

    public static String promptToPayload(Prompt prompt, QwenLlmConfig config, ChatOptions options, boolean withStream) {
        List messages = prompt.toMessages();
        Message message = (Message)CollectionUtil.lastItem((List)messages);
        Maps params = Maps.of((String)"model", (Object)Optional.ofNullable(options.getModel()).orElse(config.getModel())).set("messages", promptFormat.toMessagesJsonObject(messages)).setIf(withStream, "stream", (Object)true).setIf(withStream, "stream_options", (Object)Maps.of((String)"include_usage", (Object)true)).setIfNotEmpty("tools", promptFormat.toFunctionsJsonObject(message)).setIfContainsKey("tools", "tool_choice", (Object)MessageUtil.getToolChoice((Message)message)).setIfNotNull("top_p", (Object)options.getTopP()).setIfNotEmpty("stop", (Object)options.getStop()).setIf(map -> !map.containsKey((Object)"tools") && options.getTemperature().floatValue() > 0.0f, "temperature", (Object)options.getTemperature()).setIf(map -> !map.containsKey((Object)"tools") && options.getMaxTokens() != null, "max_tokens", (Object)options.getMaxTokens());
        if (options instanceof QwenChatOptions) {
            QwenChatOptions op = (QwenChatOptions)options;
            params.setIf(CollectionUtil.hasItems(op.getModalities()), "modalities", op.getModalities());
            params.setIf(op.getPresencePenalty() != null, "presence_penalty", (Object)op.getPresencePenalty());
            params.setIf(op.getResponseFormat() != null, "response_format", (Object)op.getResponseFormat());
            params.setIf(op.getN() != null, "n", (Object)op.getN());
            params.setIf(op.getParallelToolCalls() != null, "parallel_tool_calls", (Object)op.getParallelToolCalls());
            params.setIf(op.getTranslationOptions() != null, "translation_options", (Object)op.getTranslationOptions());
            params.setIf(op.getEnableSearch() != null, "enable_search", (Object)op.getEnableSearch());
            params.setIf(op.getEnableSearch() != null && op.getEnableSearch() != false && op.getSearchOptions() != null, "search_options", (Object)op.getSearchOptions());
            params.setIf(op.getEnableThinking() != null, "enable_thinking", (Object)op.getEnableThinking());
            params.setIf(op.getEnableThinking() != null && op.getEnableThinking() != false && op.getThinkingBudget() != null, "thinking_budget", (Object)op.getThinkingBudget());
        }
        return params.toJSON();
    }

    public static String promptToEnabledPayload(Document text, EmbeddingOptions options, QwenLlmConfig config) {
        return Maps.of((String)"model", (Object)options.getModelOrDefault(config.getModel())).set("encoding_format", (Object)"float").set("input", (Object)text.getContent()).toJSON();
    }
}

