/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.client;

import com.agentsflex.core.llm.ChatContext;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.FunctionCall;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.HistoriesPrompt;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BaseLlmClientListener
implements LlmClientListener {
    private final StreamResponseListener streamResponseListener;
    private final Prompt prompt;
    private final AiMessageParser messageParser;
    private final StringBuilder fullReasoningContent = new StringBuilder();
    private final StringBuilder fullMessage = new StringBuilder();
    private AiMessage lastAiMessage;
    private final ChatContext context;
    private final List<FunctionCallRecord> functionCallRecords = new ArrayList<FunctionCallRecord>(0);
    private FunctionCallRecord functionCallRecord;

    public BaseLlmClientListener(Llm llm, LlmClient client, StreamResponseListener streamResponseListener, Prompt prompt, AiMessageParser messageParser) {
        this.streamResponseListener = streamResponseListener;
        this.prompt = prompt;
        this.messageParser = messageParser;
        this.context = new ChatContext(llm, client);
    }

    @Override
    public void onStart(LlmClient client) {
        this.streamResponseListener.onStart(this.context);
    }

    @Override
    public void onMessage(LlmClient client, String response) {
        if (StringUtil.noText(response) || "[DONE]".equalsIgnoreCase(response.trim())) {
            if (!this.functionCallRecords.isEmpty()) {
                this.invokeOnMessageForFunctionCall(response);
            }
            return;
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)response);
            this.lastAiMessage = (AiMessage)this.messageParser.parse(jsonObject);
            String reasoningContent = this.lastAiMessage.getReasoningContent();
            String content = this.lastAiMessage.getContent();
            if (Objects.nonNull(content)) {
                this.fullMessage.append(content);
            }
            if (Objects.nonNull(reasoningContent)) {
                this.fullReasoningContent.append(reasoningContent);
            }
            this.lastAiMessage.setFullReasoningContent(this.fullReasoningContent.toString());
            this.lastAiMessage.setFullContent(this.fullMessage.toString());
            String functionName = (String)JSONPath.eval((Object)jsonObject, (String)"$.choices[0].delta.tool_calls[0].function.name");
            if (StringUtil.hasText(functionName)) {
                this.functionCallRecord = new FunctionCallRecord();
                this.functionCallRecord.name = functionName;
                this.functionCallRecord.id = (String)JSONPath.eval((Object)jsonObject, (String)"$.choices[0].delta.tool_calls[0].id");
                String arguments = (String)JSONPath.eval((Object)jsonObject, (String)"$.choices[0].delta.tool_calls[0].function.arguments");
                if (arguments != null) {
                    this.functionCallRecord.arguments = this.functionCallRecord.arguments + arguments;
                }
                this.functionCallRecords.add(this.functionCallRecord);
                this.streamResponseListener.onMatchedFunction(functionName, this.context);
            } else if (this.functionCallRecord != null) {
                String arguments = (String)JSONPath.eval((Object)jsonObject, (String)"$.choices[0].delta.tool_calls[0].function.arguments");
                if (arguments != null) {
                    this.functionCallRecord.arguments = this.functionCallRecord.arguments + arguments;
                } else {
                    String finishReason = (String)JSONPath.eval((Object)jsonObject, (String)"$.choices[0].finish_reason");
                    if ("tool_calls".equals(finishReason)) {
                        this.functionCallRecord = null;
                        this.invokeOnMessageForFunctionCall(response);
                    }
                }
            } else {
                AiMessageResponse aiMessageResponse = new AiMessageResponse(this.prompt, response, this.lastAiMessage);
                this.streamResponseListener.onMessage(this.context, aiMessageResponse);
            }
        }
        catch (Exception err) {
            this.streamResponseListener.onFailure(this.context, err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnMessageForFunctionCall(String response) {
        ArrayList<FunctionCall> calls = new ArrayList<FunctionCall>(this.functionCallRecords.size());
        for (FunctionCallRecord record : this.functionCallRecords) {
            calls.add(record.toFunctionCall());
        }
        this.lastAiMessage.setCalls(calls);
        AiMessageResponse aiMessageResponse = new AiMessageResponse(this.prompt, response, this.lastAiMessage);
        try {
            this.streamResponseListener.onMessage(this.context, aiMessageResponse);
        }
        finally {
            this.functionCallRecords.clear();
        }
    }

    @Override
    public void onStop(LlmClient client) {
        if (this.lastAiMessage != null && this.prompt instanceof HistoriesPrompt) {
            ((HistoriesPrompt)this.prompt).addMessage(this.lastAiMessage);
        }
        this.context.addLastAiMessage(this.lastAiMessage);
        this.streamResponseListener.onStop(this.context);
    }

    @Override
    public void onFailure(LlmClient client, Throwable throwable) {
        this.streamResponseListener.onFailure(this.context, throwable);
    }

    static class FunctionCallRecord {
        String id;
        String name;
        String arguments = "";

        FunctionCallRecord() {
        }

        public FunctionCall toFunctionCall() {
            FunctionCall functionCall = new FunctionCall();
            functionCall.setId(this.id);
            functionCall.setName(this.name);
            functionCall.setArgs((Map<String, Object>)JSON.parseObject((String)this.arguments));
            return functionCall;
        }
    }
}

