/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.react;

import com.agentsflex.core.llm.ChatContext;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.functions.Function;
import com.agentsflex.core.llm.functions.Parameter;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.prompt.HistoriesPrompt;
import com.agentsflex.core.react.ReActAgentListener;
import com.agentsflex.core.react.ReActStep;
import com.agentsflex.core.react.ReActStepParser;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ReActAgent {
    private static final String DEFAULT_PROMPT_TEMPLATE = "\u4f60\u662f\u4e00\u4e2a ReAct Agent\uff0c\u7ed3\u5408 Reasoning\uff08\u63a8\u7406\uff09\u548c Action\uff08\u884c\u52a8\uff09\u6765\u89e3\u51b3\u95ee\u9898\u3002\n\u4f46\u5728\u5904\u7406\u7528\u6237\u95ee\u9898\u65f6\uff0c\u8bf7\u9996\u5148\u5224\u65ad\uff1a\n1. \u5982\u679c\u95ee\u9898\u53ef\u4ee5\u901a\u8fc7\u4f60\u7684\u5e38\u8bc6\u6216\u5df2\u6709\u77e5\u8bc6\u76f4\u63a5\u56de\u7b54 \u2192 \u8bf7\u5ffd\u7565 ReAct \u6846\u67b6\uff0c\u76f4\u63a5\u8f93\u51fa\u81ea\u7136\u8bed\u8a00\u56de\u7b54\u3002\n2. \u5982\u679c\u95ee\u9898\u9700\u8981\u8c03\u7528\u7279\u5b9a\u5de5\u5177\u624d\u80fd\u89e3\u51b3\uff08\u5982\u67e5\u8be2\u3001\u8ba1\u7b97\u3001\u83b7\u53d6\u5916\u90e8\u4fe1\u606f\u7b49\uff09\u2192 \u8bf7\u4e25\u683c\u6309\u7167 ReAct \u683c\u5f0f\u54cd\u5e94\u3002\n\n\u5982\u679c\u4f60\u9009\u62e9\u4f7f\u7528 ReAct \u6a21\u5f0f\uff0c\u8bf7\u9075\u5faa\u4ee5\u4e0b\u683c\u5f0f\uff1a\nThought: \u63cf\u8ff0\u4f60\u5bf9\u5f53\u524d\u95ee\u9898\u7684\u7406\u89e3\uff0c\u5305\u62ec\u5df2\u77e5\u4fe1\u606f\u548c\u7f3a\u5931\u4fe1\u606f\uff0c\u8bf4\u660e\u4f60\u4e0b\u4e00\u6b65\u5c06\u91c7\u53d6\u4ec0\u4e48\u884c\u52a8\u53ca\u5176\u539f\u56e0\u3002\nAction: \u4ece\u4e0b\u65b9\u5217\u51fa\u7684\u5de5\u5177\u4e2d\u9009\u62e9\u4e00\u4e2a\u5408\u9002\u7684\u5de5\u5177\uff0c\u4ec5\u8f93\u51fa\u5de5\u5177\u540d\u79f0\uff0c\u4e0d\u5f97\u865a\u6784\u3002\nAction Input: \u4f7f\u7528\u6807\u51c6 JSON \u683c\u5f0f\u63d0\u4f9b\u8be5\u5de5\u5177\u6240\u9700\u7684\u53c2\u6570\uff0c\u786e\u4fdd\u5b57\u6bb5\u540d\u4e0e\u5de5\u5177\u63cf\u8ff0\u4e00\u81f4\u3002\n\n\u5728 ReAct \u6a21\u5f0f\u4e0b\uff0c\u5982\u679c\u4f60\u5df2\u83b7\u5f97\u8db3\u591f\u4fe1\u606f\u53ef\u4ee5\u76f4\u63a5\u56de\u7b54\u7528\u6237\uff0c\u8bf7\u8f93\u51fa\uff1a\nFinal Answer: [\u4f60\u7684\u56de\u7b54]\n\n\u6ce8\u610f\u4e8b\u9879\uff1a\n1. \u6bcf\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u5de5\u5177\u5e76\u6267\u884c\u4e00\u4e2a\u52a8\u4f5c\u3002\n2. \u5728\u672a\u6536\u5230\u5de5\u5177\u6267\u884c\u7ed3\u679c\u524d\uff0c\u4e0d\u8981\u81ea\u884c\u5047\u8bbe\u5176\u8f93\u51fa\u3002\n3. \u4e0d\u5f97\u7f16\u9020\u5de5\u5177\u6216\u53c2\u6570\uff0c\u6240\u6709\u5de5\u5177\u5747\u5217\u4e8e\u4e0b\u65b9\u3002\n4. \u8f93\u51fa\u987a\u5e8f\u5fc5\u987b\u4e3a\uff1aThought \u2192 Action \u2192 Action Input\u3002\n\n### \u53ef\u7528\u5de5\u5177\u5217\u8868\uff1a\n{tools}\n\n### \u7528\u6237\u95ee\u9898\u5982\u4e0b\uff1a\n{user_input}";
    private static final int DEFAULT_MAX_ITERATIONS = 5;
    private final Llm llm;
    private final List<Function> functions;
    private final String userQuery;
    private boolean streamable = false;
    private int maxIterations = 5;
    private String promptTemplate = "\u4f60\u662f\u4e00\u4e2a ReAct Agent\uff0c\u7ed3\u5408 Reasoning\uff08\u63a8\u7406\uff09\u548c Action\uff08\u884c\u52a8\uff09\u6765\u89e3\u51b3\u95ee\u9898\u3002\n\u4f46\u5728\u5904\u7406\u7528\u6237\u95ee\u9898\u65f6\uff0c\u8bf7\u9996\u5148\u5224\u65ad\uff1a\n1. \u5982\u679c\u95ee\u9898\u53ef\u4ee5\u901a\u8fc7\u4f60\u7684\u5e38\u8bc6\u6216\u5df2\u6709\u77e5\u8bc6\u76f4\u63a5\u56de\u7b54 \u2192 \u8bf7\u5ffd\u7565 ReAct \u6846\u67b6\uff0c\u76f4\u63a5\u8f93\u51fa\u81ea\u7136\u8bed\u8a00\u56de\u7b54\u3002\n2. \u5982\u679c\u95ee\u9898\u9700\u8981\u8c03\u7528\u7279\u5b9a\u5de5\u5177\u624d\u80fd\u89e3\u51b3\uff08\u5982\u67e5\u8be2\u3001\u8ba1\u7b97\u3001\u83b7\u53d6\u5916\u90e8\u4fe1\u606f\u7b49\uff09\u2192 \u8bf7\u4e25\u683c\u6309\u7167 ReAct \u683c\u5f0f\u54cd\u5e94\u3002\n\n\u5982\u679c\u4f60\u9009\u62e9\u4f7f\u7528 ReAct \u6a21\u5f0f\uff0c\u8bf7\u9075\u5faa\u4ee5\u4e0b\u683c\u5f0f\uff1a\nThought: \u63cf\u8ff0\u4f60\u5bf9\u5f53\u524d\u95ee\u9898\u7684\u7406\u89e3\uff0c\u5305\u62ec\u5df2\u77e5\u4fe1\u606f\u548c\u7f3a\u5931\u4fe1\u606f\uff0c\u8bf4\u660e\u4f60\u4e0b\u4e00\u6b65\u5c06\u91c7\u53d6\u4ec0\u4e48\u884c\u52a8\u53ca\u5176\u539f\u56e0\u3002\nAction: \u4ece\u4e0b\u65b9\u5217\u51fa\u7684\u5de5\u5177\u4e2d\u9009\u62e9\u4e00\u4e2a\u5408\u9002\u7684\u5de5\u5177\uff0c\u4ec5\u8f93\u51fa\u5de5\u5177\u540d\u79f0\uff0c\u4e0d\u5f97\u865a\u6784\u3002\nAction Input: \u4f7f\u7528\u6807\u51c6 JSON \u683c\u5f0f\u63d0\u4f9b\u8be5\u5de5\u5177\u6240\u9700\u7684\u53c2\u6570\uff0c\u786e\u4fdd\u5b57\u6bb5\u540d\u4e0e\u5de5\u5177\u63cf\u8ff0\u4e00\u81f4\u3002\n\n\u5728 ReAct \u6a21\u5f0f\u4e0b\uff0c\u5982\u679c\u4f60\u5df2\u83b7\u5f97\u8db3\u591f\u4fe1\u606f\u53ef\u4ee5\u76f4\u63a5\u56de\u7b54\u7528\u6237\uff0c\u8bf7\u8f93\u51fa\uff1a\nFinal Answer: [\u4f60\u7684\u56de\u7b54]\n\n\u6ce8\u610f\u4e8b\u9879\uff1a\n1. \u6bcf\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u5de5\u5177\u5e76\u6267\u884c\u4e00\u4e2a\u52a8\u4f5c\u3002\n2. \u5728\u672a\u6536\u5230\u5de5\u5177\u6267\u884c\u7ed3\u679c\u524d\uff0c\u4e0d\u8981\u81ea\u884c\u5047\u8bbe\u5176\u8f93\u51fa\u3002\n3. \u4e0d\u5f97\u7f16\u9020\u5de5\u5177\u6216\u53c2\u6570\uff0c\u6240\u6709\u5de5\u5177\u5747\u5217\u4e8e\u4e0b\u65b9\u3002\n4. \u8f93\u51fa\u987a\u5e8f\u5fc5\u987b\u4e3a\uff1aThought \u2192 Action \u2192 Action Input\u3002\n\n### \u53ef\u7528\u5de5\u5177\u5217\u8868\uff1a\n{tools}\n\n### \u7528\u6237\u95ee\u9898\u5982\u4e0b\uff1a\n{user_input}";
    private ReActStepParser reActStepParser = ReActStepParser.DEFAULT;
    private final HistoriesPrompt historiesPrompt;
    private final List<ReActAgentListener> listeners = new ArrayList<ReActAgentListener>();
    private int iterationCount = 0;

    public ReActAgent(Llm llm, List<Function> functions, String userQuery) {
        this.llm = llm;
        this.functions = functions;
        this.userQuery = userQuery;
        this.historiesPrompt = new HistoriesPrompt();
    }

    public ReActAgent(Llm llm, List<Function> functions, String userQuery, HistoriesPrompt historiesPrompt) {
        this.llm = llm;
        this.functions = functions;
        this.userQuery = userQuery;
        this.historiesPrompt = historiesPrompt;
    }

    public void addListener(ReActAgentListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ReActAgentListener listener) {
        this.listeners.remove(listener);
    }

    public Llm getLlm() {
        return this.llm;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public String getUserQuery() {
        return this.userQuery;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public String getPromptTemplate() {
        return this.promptTemplate;
    }

    public void setPromptTemplate(String promptTemplate) {
        this.promptTemplate = promptTemplate;
    }

    public ReActStepParser getReActStepParser() {
        return this.reActStepParser;
    }

    public void setReActStepParser(ReActStepParser reActStepParser) {
        this.reActStepParser = reActStepParser;
    }

    public List<ReActAgentListener> getListeners() {
        return this.listeners;
    }

    public boolean isStreamable() {
        return this.streamable;
    }

    public void setStreamable(boolean streamable) {
        this.streamable = streamable;
    }

    public HistoriesPrompt getHistoriesPrompt() {
        return this.historiesPrompt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public void run() {
        try {
            String toolsDescription = this.buildToolsDescription(this.functions);
            String prompt = this.promptTemplate.replace("{tools}", toolsDescription).replace("{user_input}", this.userQuery);
            HumanMessage message = new HumanMessage(prompt);
            message.addMetadata("tools", this.functions);
            message.addMetadata("user_input", this.userQuery);
            message.addMetadata("type", "reActWrapper");
            this.historiesPrompt.addMessage(message);
            if (this.isStreamable()) {
                this.startNextReActStepStream();
            } else {
                this.startNextReactStepNormal();
            }
        }
        catch (Exception e) {
            System.err.println("\u8fd0\u884c ReAct Agent \u51fa\u9519\uff1a" + e.getMessage());
            this.notifyOnError(e);
        }
    }

    private void startNextReactStepNormal() {
        for (int i = 0; i < this.maxIterations; ++i) {
            AiMessageResponse response = this.llm.chat(this.historiesPrompt);
            String content = response.getMessage().getContent();
            this.historiesPrompt.addMessage(new AiMessage(content));
            this.notifyOnChatResponse(response);
            if (this.isReActAction(content)) {
                if (this.processReActSteps(content)) continue;
                break;
            }
            if (this.isFinalAnswer(content)) {
                String flag = this.reActStepParser.getFinalAnswerFlag();
                String answer = content.substring(content.indexOf(flag) + flag.length());
                this.notifyOnFinalAnswer(answer);
                break;
            }
            this.notifyOnNonActionResponse(response);
            break;
        }
    }

    private void startNextReActStepStream() {
        if (this.iterationCount >= this.maxIterations) {
            System.out.println("\u8fbe\u5230\u6700\u5927\u8fed\u4ee3\u6b21\u6570\uff0c\u672a\u80fd\u5f97\u51fa\u6700\u7ec8\u7b54\u6848\u3002");
            this.notifyOnMaxIterationsReached();
            return;
        }
        ++this.iterationCount;
        this.llm.chatStream(this.historiesPrompt, new StreamResponseListener(){

            @Override
            public void onMessage(ChatContext context, AiMessageResponse response) {
                ReActAgent.this.notifyOnChatResponseStream(context, response);
            }

            @Override
            public void onStop(ChatContext context) {
                AiMessage lastAiMessage = context.getLastAiMessage();
                if (lastAiMessage == null) {
                    ReActAgent.this.notifyOnError(new RuntimeException("\u6ca1\u6709\u6536\u5230\u4efb\u4f55\u56de\u590d"));
                    return;
                }
                String content = lastAiMessage.getFullContent();
                if (StringUtil.noText(content)) {
                    ReActAgent.this.notifyOnError(new RuntimeException("\u6ca1\u6709\u6536\u5230\u4efb\u4f55\u56de\u590d"));
                    return;
                }
                if (ReActAgent.this.isReActAction(content)) {
                    if (ReActAgent.this.processReActSteps(content)) {
                        ReActAgent.this.startNextReActStepStream();
                    }
                } else if (ReActAgent.this.isFinalAnswer(content)) {
                    String flag = ReActAgent.this.reActStepParser.getFinalAnswerFlag();
                    String answer = content.substring(content.indexOf(flag) + flag.length());
                    ReActAgent.this.notifyOnFinalAnswer(answer);
                } else {
                    ReActAgent.this.notifyOnNonActionResponseStream(context);
                }
            }

            @Override
            public void onFailure(ChatContext context, Throwable throwable) {
                ReActAgent.this.notifyOnError((Exception)throwable);
            }
        });
    }

    private boolean isFinalAnswer(String content) {
        return this.reActStepParser.isFinalAnswer(content);
    }

    private boolean isReActAction(String content) {
        return this.reActStepParser.isReActAction(content);
    }

    private String buildToolsDescription(List<Function> functions) {
        StringBuilder sb = new StringBuilder();
        for (Function function : functions) {
            sb.append(" - ").append(function.getName()).append("(");
            Parameter[] parameters = function.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter param = parameters[i];
                sb.append(param.getName()).append(": ").append(param.getType());
                if (i >= parameters.length - 1) continue;
                sb.append(", ");
            }
            sb.append("): ").append(function.getDescription()).append("\n");
        }
        return sb.toString();
    }

    private String buildObservationString(ReActStep step, Object result) {
        return "Action\uff1a" + step.getAction() + "\nAction Input\uff1a" + step.getActionInput() + "\nAction Result\uff1a" + result + "\n";
    }

    private boolean processReActSteps(String content) {
        List<ReActStep> reActSteps = this.reActStepParser.parse(content);
        if (reActSteps.isEmpty()) {
            System.err.println("\u672a\u68c0\u6d4b\u5230\u6709\u6548\u7684 Action \u6b65\u9aa4\uff0c\u53ef\u80fd\u5185\u5bb9\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5185\u5bb9\u4e3a:\n" + content);
            return false;
        }
        for (ReActStep step : reActSteps) {
            boolean actionExecuted = false;
            for (Function function : this.functions) {
                if (!function.getName().equals(step.getAction())) continue;
                try {
                    this.notifyOnActionStart(step);
                    JSONObject parameters = StringUtil.hasText(step.getActionInput()) ? JSON.parseObject((String)step.getActionInput()) : Collections.emptyMap();
                    Object result = function.invoke((Map<String, Object>)parameters);
                    this.notifyOnActionEnd(step, result);
                    String observation = this.buildObservationString(step, result);
                    HumanMessage humanMessage = new HumanMessage(observation + "\n\u8bf7\u7ee7\u7eed\u63a8\u7406\u4e0b\u4e00\u6b65\u3002");
                    humanMessage.addMetadata("type", "reActObservation");
                    this.historiesPrompt.addMessage(humanMessage);
                    actionExecuted = true;
                }
                catch (Exception e) {
                    System.err.println("\u8c03\u7528\u5de5\u5177\u51fa\u9519\uff1a" + e.getMessage());
                    this.notifyOnError(e);
                }
                break;
            }
            if (actionExecuted) continue;
            System.err.println("\u627e\u4e0d\u5230\u5339\u914d\u7684\u5de5\u5177\uff1a" + step.getAction());
            return false;
        }
        return true;
    }

    private void notifyOnChatResponse(AiMessageResponse response) {
        for (ReActAgentListener l : this.listeners) {
            l.onChatResponse(response);
        }
    }

    private void notifyOnNonActionResponse(AiMessageResponse response) {
        for (ReActAgentListener l : this.listeners) {
            l.onNonActionResponse(response);
        }
    }

    private void notifyOnNonActionResponseStream(ChatContext context) {
        for (ReActAgentListener l : this.listeners) {
            l.onNonActionResponseStream(context);
        }
    }

    private void notifyOnChatResponseStream(ChatContext context, AiMessageResponse response) {
        for (ReActAgentListener l : this.listeners) {
            l.onChatResponseStream(context, response);
        }
    }

    private void notifyOnFinalAnswer(String finalAnswer) {
        for (ReActAgentListener l : this.listeners) {
            l.onFinalAnswer(finalAnswer);
        }
    }

    private void notifyOnActionStart(ReActStep reActStep) {
        for (ReActAgentListener l : this.listeners) {
            l.onActionStart(reActStep);
        }
    }

    private void notifyOnActionEnd(ReActStep reActStep, Object result) {
        for (ReActAgentListener l : this.listeners) {
            l.onActionEnd(reActStep, result);
        }
    }

    private void notifyOnMaxIterationsReached() {
        for (ReActAgentListener l : this.listeners) {
            l.onMaxIterationsReached();
        }
    }

    private void notifyOnError(Exception error) {
        for (ReActAgentListener l : this.listeners) {
            l.onError(error);
        }
    }
}

