/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.ChainContext;
import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainErrorListener;
import com.agentsflex.core.chain.ChainEvent;
import com.agentsflex.core.chain.ChainEventListener;
import com.agentsflex.core.chain.ChainException;
import com.agentsflex.core.chain.ChainHolder;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.ChainNodeStatus;
import com.agentsflex.core.chain.ChainOutputListener;
import com.agentsflex.core.chain.ChainStatus;
import com.agentsflex.core.chain.ChainSuspendException;
import com.agentsflex.core.chain.ChainSuspendListener;
import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.EdgeCondition;
import com.agentsflex.core.chain.NodeCondition;
import com.agentsflex.core.chain.NodeContext;
import com.agentsflex.core.chain.NodeErrorListener;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.chain.event.ChainEndEvent;
import com.agentsflex.core.chain.event.ChainResumeEvent;
import com.agentsflex.core.chain.event.ChainStartEvent;
import com.agentsflex.core.chain.event.ChainStatusChangeEvent;
import com.agentsflex.core.chain.event.NodeEndEvent;
import com.agentsflex.core.chain.event.NodeStartEvent;
import com.agentsflex.core.prompt.template.TextPromptTemplate;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.MapUtil;
import com.agentsflex.core.util.NamedThreadPools;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chain
extends ChainNode {
    private static final Logger log = LoggerFactory.getLogger(Chain.class);
    protected Chain parent;
    protected List<Chain> children;
    protected List<ChainNode> nodes;
    protected List<ChainEdge> edges;
    protected Map<String, Object> executeResult = null;
    protected Map<Class<?>, List<ChainEventListener>> eventListeners = new HashMap(0);
    protected List<ChainOutputListener> outputListeners = new ArrayList<ChainOutputListener>();
    protected List<ChainErrorListener> chainErrorListeners = new ArrayList<ChainErrorListener>();
    protected List<NodeErrorListener> nodeErrorListeners = new ArrayList<NodeErrorListener>();
    protected List<ChainSuspendListener> suspendListeners = new ArrayList<ChainSuspendListener>();
    protected ExecutorService asyncNodeExecutors = NamedThreadPools.newFixedThreadPool("chain-executor");
    protected Phaser phaser = new Phaser(1);
    protected Map<String, NodeContext> nodeContexts = new ConcurrentHashMap<String, NodeContext>();
    protected Map<String, ChainNode> suspendNodes = new ConcurrentHashMap<String, ChainNode>();
    protected List<Parameter> suspendForParameters;
    protected ChainStatus status = ChainStatus.READY;
    protected Exception exception;
    protected String message;

    public Chain() {
        this.id = UUID.randomUUID().toString();
    }

    public Chain(ChainHolder holder) {
        this.id = holder.getId();
        this.name = holder.getName();
        this.description = holder.getDescription();
        this.parent = holder.getParent() == null ? null : new Chain(holder.getParent());
        this.children = holder.getChildren() == null ? null : holder.getChildren().stream().map(Chain::new).collect(Collectors.toList());
        this.nodes = holder.getNodes();
        this.edges = holder.getEdges();
        this.executeResult = holder.getExecuteResult();
        this.nodeContexts = holder.getNodeContexts();
        this.suspendNodes = holder.getSuspendNodes();
        this.suspendForParameters = holder.getSuspendForParameters();
        this.status = holder.getStatus();
        this.message = holder.getMessage();
    }

    public Map<Class<?>, List<ChainEventListener>> getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(Map<Class<?>, List<ChainEventListener>> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public synchronized void addEventListener(Class<? extends ChainEvent> eventClass, ChainEventListener listener) {
        List chainEventListeners = this.eventListeners.computeIfAbsent(eventClass, k -> new ArrayList());
        chainEventListeners.add(listener);
    }

    public synchronized void addEventListener(ChainEventListener listener) {
        List chainEventListeners = this.eventListeners.computeIfAbsent(ChainEvent.class, k -> new ArrayList());
        chainEventListeners.add(listener);
    }

    public synchronized void removeEventListener(ChainEventListener listener) {
        for (List<ChainEventListener> list : this.eventListeners.values()) {
            list.removeIf(item -> item == listener);
        }
    }

    public synchronized void removeEventListener(Class<? extends ChainEvent> eventClass, ChainEventListener listener) {
        List<ChainEventListener> list = this.eventListeners.get(eventClass);
        if (list != null && !list.isEmpty()) {
            list.removeIf(item -> item == listener);
        }
    }

    public synchronized void addErrorListener(ChainErrorListener listener) {
        this.chainErrorListeners.add(listener);
    }

    public synchronized void removeErrorListener(ChainErrorListener listener) {
        this.chainErrorListeners.remove(listener);
    }

    public synchronized void addNodeErrorListener(NodeErrorListener listener) {
        this.nodeErrorListeners.add(listener);
    }

    public synchronized void removeNodeErrorListener(NodeErrorListener listener) {
        this.nodeErrorListeners.remove(listener);
    }

    public synchronized void addSuspendListener(ChainSuspendListener listener) {
        this.suspendListeners.add(listener);
    }

    public synchronized void removeSuspendListener(ChainSuspendListener listener) {
        this.suspendListeners.remove(listener);
    }

    public List<ChainOutputListener> getOutputListeners() {
        return this.outputListeners;
    }

    public void setOutputListeners(List<ChainOutputListener> outputListeners) {
        this.outputListeners = outputListeners;
    }

    public void addOutputListener(ChainOutputListener outputListener) {
        if (this.outputListeners == null) {
            this.outputListeners = new ArrayList<ChainOutputListener>();
        }
        this.outputListeners.add(outputListener);
    }

    public List<ChainNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<ChainNode> chainNodes) {
        this.nodes = chainNodes;
    }

    public void addNode(ChainNode chainNode) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<ChainNode>();
        }
        if (chainNode instanceof ChainEventListener) {
            this.addEventListener((ChainEventListener)((Object)chainNode));
        }
        if (chainNode.getId() == null) {
            chainNode.setId(UUID.randomUUID().toString());
        }
        if (chainNode instanceof Chain) {
            ((Chain)chainNode).parent = this;
            this.addChild((Chain)chainNode);
        }
        this.nodes.add(chainNode);
    }

    private void addChild(Chain child) {
        if (this.children == null) {
            this.children = new ArrayList<Chain>();
        }
        this.children.add(child);
    }

    public ChainStatus getStatus() {
        return this.status;
    }

    public void setStatus(ChainStatus status) {
        this.status = status;
    }

    public void setStatusAndNotifyEvent(ChainStatus status) {
        ChainStatus before = this.status;
        this.status = status;
        if (before != status) {
            this.notifyEvent(new ChainStatusChangeEvent(this, this.status, before));
        }
    }

    public Chain getParent() {
        return this.parent;
    }

    public void setParent(Chain parent) {
        this.parent = parent;
    }

    public List<Chain> getChildren() {
        return this.children;
    }

    public void setChildren(List<Chain> children) {
        this.children = children;
    }

    public void notifyEvent(ChainEvent event) {
        for (Map.Entry<Class<?>, List<ChainEventListener>> entry : this.eventListeners.entrySet()) {
            if (!entry.getKey().isInstance(event)) continue;
            for (ChainEventListener chainEventListener : entry.getValue()) {
                chainEventListener.onEvent(event, this);
            }
        }
        if (this.parent != null) {
            this.parent.notifyEvent(event);
        }
    }

    public Map<String, Object> getExecuteResult() {
        return this.executeResult;
    }

    public void setExecuteResult(Map<String, Object> executeResult) {
        this.executeResult = executeResult;
    }

    public List<ChainErrorListener> getChainErrorListeners() {
        return this.chainErrorListeners;
    }

    public void setChainErrorListeners(List<ChainErrorListener> chainErrorListeners) {
        this.chainErrorListeners = chainErrorListeners;
    }

    public List<NodeErrorListener> getNodeErrorListeners() {
        return this.nodeErrorListeners;
    }

    public void setNodeErrorListeners(List<NodeErrorListener> nodeErrorListeners) {
        this.nodeErrorListeners = nodeErrorListeners;
    }

    public List<ChainSuspendListener> getSuspendListeners() {
        return this.suspendListeners;
    }

    public void setSuspendListeners(List<ChainSuspendListener> suspendListeners) {
        this.suspendListeners = suspendListeners;
    }

    public Map<String, NodeContext> getNodeContexts() {
        return this.nodeContexts;
    }

    public void setNodeContexts(Map<String, NodeContext> nodeContexts) {
        this.nodeContexts = nodeContexts;
    }

    public Map<String, ChainNode> getSuspendNodes() {
        return this.suspendNodes;
    }

    public void setSuspendNodes(Map<String, ChainNode> suspendNodes) {
        this.suspendNodes = suspendNodes;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Phaser getPhaser() {
        return this.phaser;
    }

    public void setPhaser(Phaser phaser) {
        this.phaser = phaser;
    }

    public void set(String key, Object value) {
        this.memory.put(key, value);
    }

    public Object get(String key) {
        if (StringUtil.noText(key)) {
            return null;
        }
        Object result = this.memory.get(key);
        if (result != null) {
            return result;
        }
        List<String> parts = Arrays.asList(key.split("\\."));
        if (parts.isEmpty()) {
            return null;
        }
        int matchedLevels = 0;
        for (int i = parts.size(); i > 0; --i) {
            String tryKey = String.join((CharSequence)".", parts.subList(0, i));
            Object tempResult = this.memory.get(tryKey);
            if (tempResult == null) continue;
            result = tempResult;
            matchedLevels = i;
            break;
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Collection) {
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object item : (Collection)result) {
                results.add(Chain.getResult(parts, matchedLevels, item));
            }
            return results;
        }
        return Chain.getResult(parts, matchedLevels, result);
    }

    private static Object getResult(List<String> parts, int matchedLevels, Object result) {
        List<String> remainingParts = parts.subList(matchedLevels, parts.size());
        String jsonPath = "$." + String.join((CharSequence)".", remainingParts);
        try {
            return JSONPath.eval((Object)result, (String)jsonPath);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected Map<String, Object> execute(Chain parent) {
        return this.executeForResult(parent.getMemory().getAll());
    }

    public void execute(Map<String, Object> variables) {
        this.runInLifeCycle(variables, new ChainStartEvent(this, variables), this::executeInternal);
    }

    public Map<String, Object> executeForResult(Map<String, Object> variables) {
        return this.executeForResult(variables, false);
    }

    public Map<String, Object> executeForResult(Map<String, Object> variables, boolean ignoreError) {
        if (this.status == ChainStatus.SUSPEND) {
            this.resume(variables);
        } else {
            this.runInLifeCycle(variables, new ChainStartEvent(this, variables), this::executeInternal);
        }
        if (!ignoreError) {
            if (this.status == ChainStatus.FINISHED_ABNORMAL) {
                if (this.exception != null) {
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    throw new ChainException(this.exception);
                }
                if (this.message == null) {
                    this.message = "Chain execute error";
                }
                throw new ChainException(this.message);
            }
            if (this.status == ChainStatus.SUSPEND && this.exception != null) {
                throw (ChainSuspendException)this.exception;
            }
        }
        return this.executeResult;
    }

    @Override
    public List<Parameter> getParameters() {
        List<ChainNode> startNodes = this.getStartNodes();
        if (startNodes == null || startNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (ChainNode node : startNodes) {
            List<Parameter> nodeParameters = node.getParameters();
            if (nodeParameters == null) continue;
            parameters.addAll(nodeParameters);
        }
        return parameters;
    }

    public Map<String, Object> getParameterValues(ChainNode node) {
        return this.getParameterValues(node, node.getParameters());
    }

    public Map<String, Object> getParameterValues(ChainNode node, List<Parameter> parameters) {
        return this.getParameterValues(node, parameters, null);
    }

    public Map<String, Object> getParameterValues(ChainNode node, List<Parameter> parameters, Map<String, Object> formatArgs) {
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (Parameter parameter : parameters) {
            RefType refType = parameter.getRefType();
            Object value = refType == RefType.FIXED ? (formatArgs != null && !formatArgs.isEmpty() ? TextPromptTemplate.of(parameter.getValue()).formatToString(formatArgs) : parameter.getValue()) : (refType == RefType.REF ? this.get(parameter.getRef()) : this.get(parameter.getName()));
            if (value == null && parameter.getDefaultValue() != null) {
                value = parameter.getDefaultValue();
            }
            if (parameter.isRequired() && (value == null || value instanceof String && StringUtil.noText((String)value))) {
                if (refType == RefType.INPUT) {
                    this.addSuspendForParameter(parameter);
                    this.suspend(node);
                    throw new ChainSuspendException(node.getClass() + " Missing required parameter:" + parameter.getName());
                }
                throw new ChainException(node.getName() + " Missing required parameter:" + parameter.getName());
            }
            if (value == null || value instanceof String) {
                Object object = value = value == null ? "" : ((String)value).trim();
                if (parameter.getDataType() == DataType.Boolean) {
                    value = "true".equalsIgnoreCase((String)value) || "1".equalsIgnoreCase((String)value);
                } else if (parameter.getDataType() == DataType.Number) {
                    value = Long.parseLong((String)value);
                }
            }
            variables.put(parameter.getName(), value);
        }
        return variables;
    }

    public NodeContext getNodeContext(ChainNode chainNode) {
        return MapUtil.computeIfAbsent(this.nodeContexts, chainNode.getId(), k -> new NodeContext());
    }

    protected void executeInternal() {
        List<ChainNode> currentNodes = this.getStartNodes();
        if (currentNodes == null || currentNodes.isEmpty()) {
            return;
        }
        ArrayList<ExecuteNode> executeNodes = new ArrayList<ExecuteNode>();
        for (ChainNode currentNode : currentNodes) {
            executeNodes.add(new ExecuteNode(currentNode, null, ""));
        }
        this.doExecuteNodes(executeNodes);
    }

    protected void doExecuteNodes(List<ExecuteNode> executeNodes) {
        for (ExecuteNode executeNode : executeNodes) {
            ChainNode currentNode = executeNode.currentNode;
            if (currentNode.isAsync()) {
                this.phaser.register();
                this.asyncNodeExecutors.execute(() -> {
                    try {
                        this.doExecuteNode(executeNode);
                    }
                    finally {
                        this.phaser.arriveAndDeregister();
                    }
                });
                continue;
            }
            this.doExecuteNode(executeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecuteNode(ExecuteNode executeNode) {
        if (this.getStatus() != ChainStatus.RUNNING) {
            return;
        }
        ChainNode currentNode = executeNode.currentNode;
        NodeContext nodeContext = this.getNodeContext(currentNode);
        try {
            this.onNodeExecuteBefore(nodeContext);
            nodeContext.recordTrigger(executeNode);
            NodeCondition nodeCondition = currentNode.getCondition();
            if (nodeCondition != null && !nodeCondition.check(this, nodeContext)) {
                return;
            }
            Map<String, Object> executeResult = null;
            try {
                ChainContext.setNode(currentNode);
                this.notifyEvent(new NodeStartEvent(this, currentNode));
                if (this.getStatus() != ChainStatus.RUNNING) {
                    return;
                }
                currentNode.setNodeStatus(ChainNodeStatus.RUNNING);
                this.onNodeExecuteStart(nodeContext);
                try {
                    this.suspendNodes.remove(currentNode.getId());
                    executeResult = currentNode.execute(this);
                }
                finally {
                    nodeContext.recordExecute(executeNode);
                    this.executeResult = executeResult;
                }
            }
            catch (Throwable error) {
                currentNode.setNodeStatus(ChainNodeStatus.ERROR);
                this.notifyNodeError(error, currentNode, executeResult);
                throw error;
            }
            finally {
                currentNode.setNodeStatusFinished();
                this.onNodeExecuteEnd(nodeContext);
                ChainContext.clearNode();
                this.notifyEvent(new NodeEndEvent(this, currentNode, executeResult));
            }
            if (executeResult != null && !executeResult.isEmpty()) {
                executeResult.forEach((s, o) -> this.memory.put(currentNode.id + "." + s, o));
            }
        }
        finally {
            this.onNodeExecuteAfter(nodeContext);
        }
        if (this.getStatus() != ChainStatus.RUNNING) {
            return;
        }
        List<ChainEdge> outwardEdges = currentNode.getOutwardEdges();
        if (CollectionUtil.hasItems(outwardEdges)) {
            ArrayList<ExecuteNode> nextExecuteNodes = new ArrayList<ExecuteNode>(outwardEdges.size());
            for (ChainEdge chainEdge : outwardEdges) {
                EdgeCondition condition;
                ChainNode nextNode = this.getNodeById(chainEdge.getTarget());
                if (nextNode == null || (condition = chainEdge.getCondition()) != null && !condition.check(this, chainEdge)) continue;
                nextExecuteNodes.add(new ExecuteNode(nextNode, currentNode, chainEdge.getId()));
            }
            this.doExecuteNodes(nextExecuteNodes);
        }
    }

    protected void onNodeExecuteAfter(NodeContext nodeContext) {
    }

    protected void onNodeExecuteEnd(NodeContext nodeContext) {
    }

    protected void onNodeExecuteStart(NodeContext nodeContext) {
    }

    protected void onNodeExecuteBefore(NodeContext nodeContext) {
    }

    private List<ChainNode> getStartNodes() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return null;
        }
        if (!this.suspendNodes.isEmpty()) {
            return this.suspendNodes.values().stream().collect(Collectors.toList());
        }
        ArrayList<ChainNode> nodes = new ArrayList<ChainNode>();
        for (ChainNode node : this.nodes) {
            if (!CollectionUtil.noItems(node.getInwardEdges())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private ChainNode getNodeById(String id) {
        if (id == null || StringUtil.noText(id)) {
            return null;
        }
        for (ChainNode node : this.nodes) {
            if (!id.equals(node.getId())) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInLifeCycle(Map<String, Object> variables, ChainEvent startEvent, Runnable runnable) {
        if (variables != null) {
            this.memory.putAll(variables);
        }
        try {
            ChainContext.setChain(this);
            this.notifyEvent(startEvent);
            try {
                this.setStatusAndNotifyEvent(ChainStatus.RUNNING);
                runnable.run();
            }
            catch (ChainSuspendException cse) {
                this.notifySuspend();
                this.exception = cse;
            }
            catch (Exception e) {
                this.exception = e;
                this.setStatusAndNotifyEvent(ChainStatus.ERROR);
                this.notifyError(e);
            }
            this.phaser.arriveAndAwaitAdvance();
            if (this.status == ChainStatus.RUNNING) {
                this.setStatusAndNotifyEvent(ChainStatus.FINISHED_NORMAL);
            } else if (this.status == ChainStatus.ERROR) {
                this.setStatusAndNotifyEvent(ChainStatus.FINISHED_ABNORMAL);
            }
        }
        finally {
            ChainContext.clearChain();
            this.notifyEvent(new ChainEndEvent(this));
        }
    }

    private void notifyOutput(ChainNode node, Object response) {
        for (ChainOutputListener inputListener : this.outputListeners) {
            inputListener.onOutput(this, node, response);
        }
        if (this.parent != null) {
            this.parent.notifyOutput(node, response);
        }
    }

    private void notifySuspend() {
        for (ChainSuspendListener suspendListener : this.suspendListeners) {
            suspendListener.onSuspend(this);
        }
        if (this.parent != null) {
            this.parent.notifySuspend();
        }
    }

    private void notifyError(Throwable error) {
        for (ChainErrorListener errorListener : this.chainErrorListeners) {
            errorListener.onError(error, this);
        }
        if (this.parent != null) {
            this.parent.notifyError(error);
        }
    }

    private void notifyNodeError(Throwable error, ChainNode node, Map<String, Object> executeResult) {
        for (NodeErrorListener errorListener : this.nodeErrorListeners) {
            errorListener.onError(error, node, executeResult, this);
        }
        if (this.parent != null) {
            this.parent.notifyNodeError(error, node, executeResult);
        }
    }

    public void stopNormal(String message) {
        this.message = message;
        this.setStatusAndNotifyEvent(ChainStatus.FINISHED_NORMAL);
    }

    public void stopError(String message) {
        this.message = message;
        this.setStatusAndNotifyEvent(ChainStatus.FINISHED_ABNORMAL);
    }

    public void output(ChainNode node, Object response) {
        this.notifyOutput(node, response);
    }

    public String getMessage() {
        return this.message;
    }

    public List<ChainEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<ChainEdge> edges) {
        this.edges = edges;
    }

    public void addEdge(ChainEdge edge) {
        if (this.edges == null) {
            this.edges = new ArrayList<ChainEdge>();
        }
        this.edges.add(edge);
        boolean findSource = false;
        boolean findTarget = false;
        for (ChainNode node : this.nodes) {
            if (node.getId().equals(edge.getSource())) {
                node.addOutwardEdge(edge);
                findSource = true;
            } else if (node.getId().equals(edge.getTarget())) {
                node.addInwardEdge(edge);
                findTarget = true;
            }
            if (!findSource || !findTarget) continue;
            break;
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ExecutorService getAsyncNodeExecutors() {
        return this.asyncNodeExecutors;
    }

    public void setAsyncNodeExecutors(ExecutorService asyncNodeExecutors) {
        this.asyncNodeExecutors = asyncNodeExecutors;
    }

    public List<Parameter> getSuspendForParameters() {
        return this.suspendForParameters;
    }

    public void setSuspendForParameters(List<Parameter> suspendForParameters) {
        this.suspendForParameters = suspendForParameters;
    }

    public void addSuspendForParameter(Parameter suspendForParameter) {
        if (this.suspendForParameters == null) {
            this.suspendForParameters = new ArrayList<Parameter>();
        }
        this.suspendForParameters.add(suspendForParameter);
    }

    public void suspend(ChainNode node) {
        try {
            this.suspendNodes.putIfAbsent(node.getId(), node);
        }
        finally {
            this.setStatusAndNotifyEvent(ChainStatus.SUSPEND);
        }
    }

    public void resume(Map<String, Object> variables) {
        this.runInLifeCycle(variables, new ChainResumeEvent(this, variables), this::executeInternal);
    }

    public void reset() {
        this.memory.clear();
        this.nodeStatus = ChainNodeStatus.READY;
        this.status = ChainStatus.READY;
        this.executeResult = null;
        this.message = null;
        this.exception = null;
        this.nodeContexts.clear();
        if (this.suspendNodes != null) {
            this.suspendNodes.clear();
        }
        if (this.suspendForParameters != null) {
            this.suspendForParameters.clear();
        }
        this.asyncNodeExecutors = NamedThreadPools.newFixedThreadPool("chain-executor");
        this.phaser = new Phaser(1);
    }

    public String toString() {
        return "Chain{id='" + this.id + '\'' + ", memory=" + this.memory + ", eventListeners=" + this.eventListeners + ", outputListeners=" + this.outputListeners + ", nodes=" + this.nodes + ", lines=" + this.edges + ", status=" + (Object)((Object)this.status) + ", message='" + this.message + '\'' + '}';
    }

    public static class ExecuteNode {
        final ChainNode currentNode;
        final ChainNode prevNode;
        final String fromEdgeId;

        public ExecuteNode(ChainNode currentNode, ChainNode prevNode, String fromEdgeId) {
            this.currentNode = currentNode;
            this.prevNode = prevNode;
            this.fromEdgeId = fromEdgeId;
        }
    }
}

