/*
 * Decompiled with CFR 0.152.
 */
package cn.yiynx.xif.core;

import cn.yiynx.xif.core.Xif;
import cn.yiynx.xif.core.XifHandler;
import cn.yiynx.xif.core.XifListener;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.aop.scope.ScopedObject;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@Component
public class XifListenerMethodProcessor
implements SmartInitializingSingleton,
ApplicationContextAware,
BeanFactoryPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(XifListenerMethodProcessor.class);
    @Nullable
    private ConfigurableApplicationContext applicationContext;
    @Nullable
    private ConfigurableListableBeanFactory beanFactory;
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isTrue((boolean)(applicationContext instanceof ConfigurableApplicationContext), (String)"ApplicationContext does not implement ConfigurableApplicationContext");
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterSingletonsInstantiated() {
        String[] beanNames;
        ConfigurableListableBeanFactory beanFactory = this.beanFactory;
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"No ConfigurableListableBeanFactory set");
        for (String beanName : beanNames = beanFactory.getBeanNamesForType(Object.class)) {
            if (ScopedProxyUtils.isScopedTarget((String)beanName)) continue;
            Class type = null;
            try {
                type = AutoProxyUtils.determineTargetClass((ConfigurableListableBeanFactory)beanFactory, (String)beanName);
            }
            catch (Throwable ex) {
                log.debug("Could not resolve target class for bean with name {}", (Object)beanName, (Object)ex);
            }
            if (type == null) continue;
            if (ScopedObject.class.isAssignableFrom(type)) {
                try {
                    Class targetClass = AutoProxyUtils.determineTargetClass((ConfigurableListableBeanFactory)beanFactory, (String)ScopedProxyUtils.getTargetBeanName((String)beanName));
                    if (targetClass != null) {
                        type = targetClass;
                    }
                }
                catch (Throwable ex) {
                    log.debug("Could not resolve target bean for scoped proxy {}", (Object)beanName, (Object)ex);
                }
            }
            try {
                this.processBean(beanName, type);
            }
            catch (Throwable ex) {
                throw new BeanInitializationException("Failed to process @XifListener annotation on bean with name '" + beanName + "'", ex);
            }
        }
    }

    private void processBean(final String beanName, Class<?> targetType) {
        if (!this.nonAnnotatedClasses.contains(targetType) && AnnotationUtils.isCandidateClass(targetType, XifListener.class) && !XifListenerMethodProcessor.isSpringContainerClass(targetType)) {
            Map annotatedMethods = null;
            try {
                annotatedMethods = MethodIntrospector.selectMethods(targetType, method -> (XifListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, XifListener.class));
            }
            catch (Throwable ex) {
                log.debug("Could not resolve methods for bean with name {}", (Object)beanName, (Object)ex);
            }
            if (CollectionUtils.isEmpty((Map)annotatedMethods)) {
                this.nonAnnotatedClasses.add(targetType);
                log.trace("No @XifListener annotations found on bean class: {}", (Object)targetType.getName());
            } else {
                final ConfigurableApplicationContext context = this.applicationContext;
                Assert.state((context != null ? 1 : 0) != 0, (String)"No ApplicationContext set");
                for (final Method method2 : annotatedMethods.keySet()) {
                    final XifListener xifListener = method2.getAnnotation(XifListener.class);
                    XifHandler xifHandler = new XifHandler(){

                        @Override
                        public String getGroup() {
                            return xifListener.group();
                        }

                        @Override
                        public String getCondition() {
                            return xifListener.condition();
                        }

                        @Override
                        public String getParamName() {
                            return method2.getParameters()[0].getName();
                        }

                        @Override
                        public <T> Object handler(T param) {
                            try {
                                log.debug("group:{}, condition:{}, param:{}, is-xif-condition-pass:true, xif-handler->{}", new Object[]{xifListener.group(), xifListener.condition(), param, method2});
                                return method2.invoke(context.getBean(beanName), param);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                    Xif.register(xifHandler);
                }
            }
        }
    }

    private static boolean isSpringContainerClass(Class<?> clazz) {
        return clazz.getName().startsWith("org.springframework.") && !AnnotatedElementUtils.isAnnotated((AnnotatedElement)ClassUtils.getUserClass(clazz), Component.class);
    }
}

