/*
 * Decompiled with CFR 0.152.
 */
package cn.yiynx.xif.core;

import cn.yiynx.xif.core.XifHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Xif {
    private static final Logger log = LoggerFactory.getLogger(Xif.class);
    private static final Map<String, List<XifHandler>> XIF_HANDLER_MAP = new HashMap<String, List<XifHandler>>();
    private static final ExpressionParser parser = new SpelExpressionParser();
    private static final Map<String, Boolean> CHECK_XIF_HANDLER_REPEAT = new HashMap<String, Boolean>();

    private Xif() {
    }

    public static void register(XifHandler xifHandler) {
        log.info("Xif-register->group:{}, condition:{}", (Object)xifHandler.getGroup(), (Object)xifHandler.getCondition());
        Assert.hasText((String)xifHandler.getGroup(), (String)"xif-group not empty");
        Xif.preParseExpression(xifHandler.getCondition());
        String uniqueKey = xifHandler.getGroup().concat("->").concat(StringUtils.hasText((String)xifHandler.getCondition()) ? xifHandler.getCondition() : "else");
        log.debug("XIF-uniqueKey:{}", (Object)uniqueKey);
        Assert.isTrue((CHECK_XIF_HANDLER_REPEAT.putIfAbsent(uniqueKey, Boolean.TRUE) == null ? 1 : 0) != 0, (String)"xif-group:condition already exists");
        if (!XIF_HANDLER_MAP.containsKey(xifHandler.getGroup())) {
            XIF_HANDLER_MAP.put(xifHandler.getGroup(), new ArrayList());
        }
        XIF_HANDLER_MAP.get(xifHandler.getGroup()).add(xifHandler);
        log.debug("xif-handler:{}", XIF_HANDLER_MAP);
    }

    private static void preParseExpression(String condition) {
        if (!StringUtils.hasText((String)condition)) {
            return;
        }
        try {
            parser.parseExpression(condition);
        }
        catch (ParseException e) {
            log.error("XifHandler-condition-error\uff01");
            throw e;
        }
    }

    public static <T> Object handler(String group, T param) {
        log.debug("group:{}, param:{}", (Object)group, param);
        SpelExpressionParser parser = new SpelExpressionParser();
        Optional<XifHandler> xifHandlerOptional = Optional.ofNullable(XIF_HANDLER_MAP.get(group)).orElseThrow(() -> new IllegalArgumentException("xif-group\uff08" + group + "\uff09not found")).stream().filter(XifHandler::isIf).filter(arg_0 -> Xif.lambda$handler$1((ExpressionParser)parser, param, arg_0)).findAny();
        if (xifHandlerOptional.isPresent()) {
            return xifHandlerOptional.get().handler(param);
        }
        xifHandlerOptional = XIF_HANDLER_MAP.get(group).stream().filter(XifHandler::isElse).findAny();
        if (xifHandlerOptional.isPresent()) {
            return xifHandlerOptional.get().handler(param);
        }
        log.debug("group:{}, param:{}\uff08xif-handler-no-match: return null\uff09", (Object)group, param);
        return null;
    }

    private static /* synthetic */ boolean lambda$handler$1(ExpressionParser parser, Object param, XifHandler xifHandler) {
        Boolean isConditionPass;
        Expression expression = parser.parseExpression(xifHandler.getCondition());
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariable(xifHandler.getParamName(), param);
        try {
            isConditionPass = (Boolean)expression.getValue((EvaluationContext)context, Boolean.class);
        }
        catch (EvaluationException e) {
            log.error("xif-condition error\uff08The result is not of type Boolean\uff09\uff01group:{}, condition:{}, param:{}", new Object[]{xifHandler.getGroup(), xifHandler.getCondition(), param});
            throw e;
        }
        if (Boolean.FALSE.equals(isConditionPass)) {
            log.debug("group:{}, condition:{}, param:{}, is-xif-condition-pass:{}", new Object[]{xifHandler.getGroup(), xifHandler.getCondition(), param, isConditionPass});
        }
        return isConditionPass;
    }
}

