/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Token;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Tokenizer
implements Iterator,
Cloneable {
    protected String content;
    protected int currIdx = 0;
    protected int length;
    private Token aheadToken = null;
    private int aheadIdx = 0;

    public Tokenizer(String content) {
        this.content = content;
        this.length = content.length();
    }

    public Token nextToken() {
        if (this.aheadToken != null) {
            Token token = this.aheadToken;
            this.aheadToken = null;
            this.currIdx = this.aheadIdx;
            return token;
        }
        return this.nextTokenInt();
    }

    public Token nextTokenInt() {
        boolean INITIAL = false;
        boolean UNPARSED = true;
        int IDENT = 2;
        int state = 0;
        int startIdx = this.currIdx;
        while (true) {
            char curr = this.currIdx < this.length ? this.content.charAt(this.currIdx) : (char)'\u0000';
            switch (state) {
                case 0: {
                    if (this.currIdx < this.length && Character.isWhitespace(curr)) {
                        ++startIdx;
                        break;
                    }
                    if (this.currIdx < this.length && curr == '\'') {
                        ++startIdx;
                        state = 1;
                        break;
                    }
                    if (this.currIdx < this.length && Character.isJavaIdentifierStart(curr)) {
                        state = 2;
                        break;
                    }
                    if (curr == '\u0000') {
                        return new Token(0, "");
                    }
                    ++this.currIdx;
                    return new Token(-1, String.valueOf(curr));
                }
                case 1: {
                    int n;
                    if (this.currIdx < this.length && curr != '\'') break;
                    if (this.currIdx < this.length) {
                        int n2 = this.currIdx;
                        n = n2;
                        this.currIdx = n2 + 1;
                    } else {
                        n = this.currIdx;
                    }
                    return new Token(1, this.content.substring(startIdx, n));
                }
                case 2: {
                    if (this.currIdx < this.length && Character.isJavaIdentifierPart(curr)) break;
                    return new Token(2, this.content.substring(startIdx, this.currIdx));
                }
            }
            ++this.currIdx;
        }
    }

    public Token getLookahead() {
        if (this.aheadToken == null) {
            int prevIdx = this.currIdx;
            this.aheadToken = this.nextToken();
            this.aheadIdx = this.currIdx;
            this.currIdx = prevIdx;
        }
        return this.aheadToken;
    }

    public String getContent() {
        return this.content.substring(this.currIdx, this.length);
    }

    public String getAcceptedContent() {
        return this.content.substring(0, this.currIdx);
    }

    public String getFullContent() {
        return this.content;
    }

    public boolean hasNext() {
        return this.getLookahead().getType() != 0;
    }

    public Object next() {
        if (this.hasNext()) {
            return this.nextToken();
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

